local modname = minetest.get_current_modname()

-- Function to apply knockback to the player 
local function apply_knockback(player, strength) 
	local look_dir = player:get_look_dir() 
	local knockback = vector.multiply(look_dir, 0-strength) 
	player:add_velocity(knockback)
end

local function on_leftclick(itemstack, user, pointed_thing)
	local itemdef = minetest.registered_items[itemstack:get_name()]
	local knockback_strength = itemdef.knockback
	local spellname = itemdef.spellname

	apply_knockback(user, knockback_strength) 
	
	-- Get the player's position and direction   fireball
	local pos = user:get_pos()
	local dir = user:get_look_dir()

	-- Offset to spawn the fireball in front of the player
	pos.y = pos.y + 1.5 -- Adjust height to be at the player's hand level
	local spellentity = minetest.add_entity(pos, modname..":"..spellname)

	-- Set spell's velocity
	local velocity = vector.multiply(dir, 15) -- Adjusted velocity for balance
	spellentity:set_velocity(velocity)
	spellentity:set_acceleration(vector.multiply(dir, 2))
	spellentity:set_yaw(user:get_look_horizontal())

	return itemstack
end

local function on_rightclick(itemstack, user, pointed_thing)
	c.log(type(user)) 
	return itemstack
end
 
local wandata = {
	lost_child = {

		description = "Lost Child" ..minetest.colorize("#012700",
[[

+ signature spell scream
]]),
		lore = minetest.colorize("#017200", ""..
[[We were so tired we didn't bother to check for booby traps, 
doc found something... there was so much blood. After that 
I never trusted anything, not myself not my surroundings. 
There are no guarantees in life, but we can come close. 
I'll master single spell, drill it till my hands bleed and 
my blood boils. Blood... I'll never forget that smell.
]]..
""),
		inventory_image = "wis_kinderblut.png",
		on_use = on_leftclick,
		on_place = on_rightclick,
		on_secondary_use = on_rightclick,
		knockback = 0,
		spellname = "scream"

	},


	ballpoint = {
		description = "Ball Point" ..minetest.colorize("#000127",[[

+ signature spell arrow
]]),
		lore = minetest.colorize("#000172", ""..
[[After The War moved into the cities, most mages altered their wands to 
reduce the potential for civilian casualties... instead the disaster mages 
altered there strategy.]]..
""),
		inventory_image = "wis_branch_staff.png",
		on_use = on_leftclick,
		on_place = on_rightclick,
		on_secondary_use = on_rightclick,
		knockback = 0,
		spellname = "arrow"
	},

	bloodletter = {
		description = "Blood Letter" ..minetest.colorize("#700127",
[[

+ signature spell sincerity
]]		),
		lore = minetest.colorize("#FF0127", ""..
[[the  primary wand during The War. Powered by a core of primarily blood plasma, and salt... 
it's destructive potential is unmatched. It's major drawback is the knockback caused by 
casting such powerful spells, it is considered by many to be unusable. ]]..
""),
		inventory_image = "wis_rapier.png",
		on_use = on_leftclick,
		on_place = on_rightclick,
		on_secondary_use = on_rightclick,
		knockback = 6,
		spellname = "truedeath"
	},


}

for key, value in pairs(wandata) do 
	local wand_name = table.concat({modname, key}, ":")
	minetest.log(wand_name) 
	if value and value.description and value.lore then
		value.description = table.concat({value.description, value.lore}, "\n")
	end
	minetest.register_craftitem(wand_name, value)
end
