#?replace(sub = "\t", by ="  ")
import pixie

proc containsNone(test, chars: string): bool =
	for c in chars:
		if c in test:
		  return false
	return true

proc getMaxFontSize*(text: string, fontPath: string, maxWidth: float32, maxHeight: float32): float32 =
	var fontSize: float32 = 1
	var maxHeight_l: float32 = maxHeight / 2.0
	if text.containsNone("g"):
		maxHeight_l = maxHeight_l * float32(1.3)
	while true:
		#let ctx = newContext(int(maxWidth*2), int(maxHeight_l*2))
		let font = readFont(fontPath)
		font.size = float32(fontSize)
		let bounds = typeset(font, text).layoutBounds()
		let textWidth = bounds.x
		let textHeight = bounds.y
		if textWidth/2 > maxWidth or textHeight/2 > maxHeight_l:
			return fontSize - 1
		fontSize += 1

proc newFont(typeface: Typeface, size: float32, color: Color): Font =
	result = newFont(typeface)
	result.size = size
	result.paint.color = color


#bgColor fgColor, aspect_ratio
proc generateImage*(filepath: string, text: string, fontPath: string, fontSize: float32, width: float32, height: float32 ) =
	let image = newImage(int(width), int(height))
	#let ctx = newContext(image)
	let typeface = readTypeface(fontPath)
	let font = newFont(typeface, fontSize, color(0, 0, 0, 1))
	let bounds = typeset(font, text).layoutBounds()
	let textWidth = bounds.x
	let textHeight = bounds.y
	let spans = @[
		newSpan(text, font)
	]
	image.fillText(typeset(spans, vec2(0, 0)), translate(vec2(   (width/2)-(textWidth/2)	 ,   (height/2)-(textHeight/2)	)))
	
	
	# Save the image to a file
	image.writeFile(filepath)
	echo "Image generated and saved as " & filepath


proc generateTitleImage*(filepath: string, text: string, fontPath: string) =
	let width: float32 = 315
	let height: float32 = 64
	let fontSize: float32 = getMaxFontSize(text, fontpath, width, height)
	#echo(fontSize)
	generateImage(filePath, text, fontpath, fontSize, width, height)

proc createGradientImage*(filepath: string, width: float32, height: float32) =
	let image = newImage(int(width), int(height))
	let ctx = newContext(image)
	image.fill(rgba(255, 255, 255, 255))
	# Create a vertical gradient manually
	var linerGradient = Paint(kind: LinearGradientPaint)
	linerGradient.gradientHandlePositions.add(vec2(0, 0))
	linerGradient.gradientHandlePositions.add(vec2(width, height))
	linerGradient.gradientStops.add(
		ColorStop(color: color(0, 0, 0, 1), position: 0))
	linerGradient.gradientStops.add(
		ColorStop(color: color(255, 255, 255, 255), position: 1))
	ctx.fillStyle = linerGradient
	ctx.fillRect(0, 0, width, height)
	image.writeFile(filepath)
	echo "Image created and saved as " & filepath

