local modname = minetest.get_current_modname()
local modpath = minetest.get_modpath(modname)
local print = c.log
local ename = modname..":smol_cube"
local edef2d = {
	physical = true,
	collide_with_objects = true,
	collisionbox = {0, 0, 0, 0, 0, 0},
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"wis_black.png"},
}

local cube3d = {
	physical = true,
	collide_with_objects = true,
	collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
	visual = "cube",
	visual_size = {x = 1, y = 1},
	textures = {"wis_black.png", "wis_black.png", "wis_black.png", "wis_black.png", "wis_black.png" , "wis_black.png"},
	dps = 2, -- dps (damage dealt per second when attacking)
--todo: trnsfer texture fill to cube3d
}

--keep track of metadata
local time_elapsed = 0
local max_to_spawn = 100
local despawn_distance = 50 -- distance threshold for despawning
local entity_list_ = {}

local function move_entity(self, dtime)
	if self then
		return
	end
	local pos = self.object:get_pos()
	local closest_player = nil
	local closest_distance = math.huge

	for _, player in ipairs(minetest.get_connected_players()) do
		local player_pos = player:get_pos()
		local distance = vector.distance(pos, player_pos)
		if distance < closest_distance then
			closest_distance = distance
			closest_player = player
		end
	end

	if closest_player then
		local player_pos = closest_player:get_pos()
		-- Move towards the player
		local direction = vector.direction(pos, player_pos)
		local velocity = vector.multiply(direction, 2) -- Adjust speed as needed
		self.object:set_velocity(velocity)
		self.object:set_yaw(minetest.dir_to_yaw(direction))
		-- Check for attack range (e.g., within 1.5 units)
		if closest_distance < 1.5 then
			closest_player:set_hp(closest_player:get_hp() - self.initial_properties.dps * dtime)
		end

		-- Despawn if too far away
		if closest_distance > despawn_distance then
			self.object:remove()
			-- Remove the entity from the spawned_entities table
			for i, entity in ipairs(entity_list_) do
				if entity == self.object then
					table.remove(entity_list_, i)
					break
				end
			end
		end
	else
		-- Stop moving if no players are found
		self.object:set_velocity({x = 0, y = 0, z = 0})
	end



end

-- Spawn the entity
local function tick_entity(self, dtime)
	-- Declare time if not exist
	if not self.timer then
		self.timer = 0
	end
	-- Add delta
	self.timer = self.timer + dtime
	-- Only tick one per second
	if self.timer < 1 then return end
	-- Do the thing
	move_entity(self, dtime)
end

function findPointOnCircle(center, radius, radians)
    -- Convert angle from degrees to radians
--(x1 + r * sin (a) , y + r * cos)
    local angleRad = radians --math.rad(angle)
--\left(x_{1}+r\ \sin\left(a\right),\ \ y_{1}+r\ \cos\left(a\right)\ \ \right)
    -- Calculate the second point's coordinates
    local x = ( center.x + radius ) * math.cos(angleRad)
    local y = center.y --pemdas broke my code!
    local z = ( center.z + radius ) * math.sin(angleRad)
    return {x = x, y = y, z = z}
end
-- I'm tired
local function choose_player_above_y(y_val)
	for _, player in ipairs(minetest.get_connected_players()) do -- table.shuffle()
		local player_pos = player:get_pos()
		if player_pos.y >= y_val then
			return player
		end
	end

end


-- Spawn the entity
local function spawn_entity(at_pos, radius)
	local radians = math.random(0, math.pi*2) -- In degrees?
	local pos = findPointOnCircle(at_pos, radius, radians) --player:get_pos()
	if #entity_list_ < max_to_spawn then
		minetest.add_entity(pos, ename)
		-- Print a message to the server log
		minetest.log("error", "Spawned entity at " .. minetest.pos_to_string(pos))
	else
		minetest.log("error", "Maximum number of entities reached")	

	end

end

local function despawn_all_entities()
	for _, entity in ipairs(entity_list_) do
		if entity then
			entity:remove()
		end
	end
	-- Clear the entity_list_ table
	entity_list_ = {}
	minetest.log("error", "All entities despawned")
end
minetest.register_on_respawnplayer(function(player)
	despawn_all_entities()
end)

-- Define a activeObject entity
minetest.register_entity(ename, {
	initial_properties = cube3d,
	on_activate = function(self, staticdata, dtime_s)
		-- Add the entity to the entity_list_ table
		table.insert(entity_list_, self.object)
	end,

	on_deactivate = function(self)
		-- Remove the entity from the entity_list_ table
		for i, entity in ipairs(entity_list_) do
			if entity == self.object then
				table.remove(entity_list_, i)
				break
			end
		end
	end,
	on_step = tick_entity,

	on_rightclick = function(self, clicker)
		-- Remove the entity
		self.object:remove()
		-- Send a message to the player who clicked
		minetest.chat_send_player(clicker:get_player_name(), "Entity removed!")
	end,

})

minetest.register_globalstep(function(dtime)
	-- Increment the elapsed time by the delta time (dtime) since the last step
	time_elapsed = time_elapsed + dtime
	-- Check if 5 seconds have passed
	if time_elapsed >= .5 then
		--minetest.log("error", "dtime" .. dtime)
		time_elapsed = 0
		--spawn_entity(choose_player_above_y(0):get_pos(), 25)
	end
end)

