local modName = minetest.get_current_modname()
local modPath = minetest.get_modpath(modName)
local print = c.log
local spawnCount = 0
local spawn_limit = 10
minetest.register_entity(modName..":wisp", {
	initialProperties = {
		physical = true,
		collideWithObjects = true,
		visual = "sprite",
		visualSize = {x = 1, y = 1},
		textures = {"wis_orb_full.png"},
		spriteDiv = {x = 1, y = 1},
	},
	health = 10,

	onActivate = function(self, staticdata, dtime_s)
		self.object:set_hp(self.health)
		spawnCount = spawnCount + 1
		if spawnCount > 100 then
			self.object:remove()
		end
	end,
	
	onDeactivate = function(self)
		spawnCount = spawnCount - 1
	end,

	onPunch = function(self, puncher, time_from_last_punch, tool_capabilities, dir)
		local hp = self.object:get_hp() - 1
		self.object:set_hp(hp)
		c.log("on_punch")
			
		if hp <= 0 then
			self.object:remove()
		end
	end,

	onStep = function(self, dtime)
		c.log(dtime)
	end,
})

local function isAirEquivalent(node_name)
	local nodeDef = minetest.registered_nodes[node_name]
	return nodeDef and nodeDef.groups and nodeDef.groups.sunlight_propagates
end

local function spawnBadnessAroundPlayer(player, nodeName)
	local pos = player:get_pos()
	local size = 20
	local positions = minetest.find_nodes_in_area(
		{x = pos.x - size, y = pos.y - size, z = pos.z - size},
		{x = pos.x + size, y = pos.y + size, z = pos.z + size},
		{nodeName}
	)
	if positions ~= nil then
		table.shuffle(positions)
		local playerSpawnCount = 0
		for _, pos in ipairs(positions) do
			if playerSpawnCount >= 3 then
				break
			end
			local head = {x = pos.x, y = pos.y + 2, z = pos.z}
			local tail = {x = pos.x, y = pos.y + 1, z = pos.z}
			if pos.y >= 0 then
				minetest.add_entity({x = pos.x, y = pos.y + 1, z = pos.z}, modName..":wisp")
				playerSpawnCount = playerSpawnCount + 1
				if spawnCount < spawn_limit then
					spawnCount = spawnCount + 1
				end
			end
		end
	end
end

local function spawnBadnessPerPlayers()
	local players = minetest.get_connected_players()
	for _, player in ipairs(players) do
		spawnBadnessAroundPlayer(player, "wisgame"..":stone")
	end
end

local gtimer = 0
minetest.register_globalstep(function(dtime)
	gtimer = gtimer + dtime
	if gtimer >= 1 then 
		gtimer = 0
		spawnBadnessPerPlayers()
	end
end)
