local modname = minetest.get_current_modname()
local new_particlespawner = function (texture, pos, count)
	local r = {
				amount = count,
				time = 0.1,
				minpos = vector.subtract(pos, 0.5),
				maxpos = vector.add(pos, 0.5),
				minvel = {x = -2, y = -2, z = -2},
				maxvel = {x = 2, y = 2, z = 2},
				minacc = {x = 0, y = 0, z = 0},
				maxacc = {x = 0, y = 0, z = 0},
				minexptime = 0.1,
				maxexptime = 1.0,
				minsize = 1,
				maxsize = 4,
				texture = texture,
			}
	return r
end
local new_spell = function (spell_texture, on_step_function)
	return {
		initial_properties = {
			physical = false,
			collide_with_objects = true,
			collisionbox = {0, 0, 0, 0, 0, 0},
			visual = "sprite",
			visual_size = {x = 0.5, y = 0.5},
			textures = {spell_texture},
			--{"open_clump_mask.png^(wis_green.png^(wis_green.png^[mask:open_clump_mask.png))^[makealpha:0,0,0^[invert:rgb"},
			spritediv = {x = 1, y = 1},
		},
		on_step= on_step_function
	}
end
local function apply_damage_to(self, obj)
	if obj:is_player() and false or obj:get_luaentity() then
		--[[obj:punch(self.object, 10.0, {
			full_punch_interval = 1.0,
				-- damage_groups = {fleshy = 4}, 
		}, nil)
		--]]
		obj:remove()
	end
end

local function on_tick_fireball(self, dtime)
	local pos = self.object:get_pos()
	-- apply damage on_ collision with objects and players
	for _, obj in ipairs(minetest.get_objects_inside_radius(pos, 1)) do
		apply_damage_to(self, obj)
	end
	-- check collision
	local node = minetest.get_node(pos)
	if node.name ~= "air" then
		--  Hit them with the bang bang
		--minetest.sound_play("todo.ogg", {pos = pos, gain = 1.0, max_hear_distance = 32}) -- two chunks
		--minetest.remove_node(pos)
		self.object:remove()
		minetest.add_particlespawner(new_particlespawner("wis_fire.png", pos, 1000))
	end
end
local function on_tick_raygun(self, dtime)
end
-- Register spells
local fireball = new_spell("wis_clump_mask.png^(wis_green.png^(wis_green.png^[mask:open_clump_mask.png^[colorize:#000000:70))^[makealpha:0,0,0", on_tick_fireball)
local raygun = new_spell("blank.png", on_tick_raygun)


minetest.register_entity(modname..":truedeath", fireball)--真死 (shinshi)
minetest.register_entity(modname..":arrow", fireball)
minetest.register_entity(modname..":scream", fireball)



