-- Function to spread grass to nearby dirt
local function spread_grass(pos)
	-- Define the positions to check around the current position
	local positions = {
		{x = pos.x + 1, y = pos.y, z = pos.z},
		{x = pos.x - 1, y = pos.y, z = pos.z},
		{x = pos.x, y = pos.y, z = pos.z + 1},
		{x = pos.x, y = pos.y, z = pos.z - 1},
		{x = pos.x, y = pos.y + 1, z = pos.z},
		{x = pos.x, y = pos.y - 1, z = pos.z},
	}

	for _, new_pos in ipairs(positions) do
		local node = minetest.get_node(new_pos)
		if node.name == "default:dirt" then
			minetest.set_node(new_pos, {name = "default:dirt_with_grass"})
		end
	end
end

-- ABM (Active Block Modifier) to spread grass
minetest.register_abm({
	nodenames = {"default:dirt_with_grass"},
	interval = 10,  -- Time in seconds between ABM execution
	chance = 50,	-- 1 in 50 chance for the ABM to run
	action = function(pos, node, active_object_count, active_object_count_wider)
		spread_grass(pos)
	end,
})
