--[[
-- Original table
original_table = { 1, "hello", true }

-- Metatable to track reads
metatable = {
	__index = function(t, key)
		local value = rawget(t, key)
		print("Key:", key, "Type:", type(value))
		return value
	end
}

-- Set metatable
setmetatable(original_table, metatable)

-- Access elements
print(original_table[1])
print(original_table[2])
print(original_table[3])
--]]
-- Function to check if a string is in the table
function table.contains(table, element)
	for _, value in ipairs(table) do
		if value == element then
			return true
		end
	end
	return false
end
