	-- Replace node 0,0,0, with dirt
minetest.register_on_generated(function(minp, maxp, seed)
	local vm, emin, emax = minetest.get_mapgen_object("voxelmanip")
	local data = vm:get_data()
	local area = VoxelArea:new{MinEdge = emin, MaxEdge = emax}
	local grassdef = minetest.get_content_id("mapgen_dirt_with_grass")
	for z = minp.z, maxp.z do
		for y = minp.y, maxp.y do
			if x == 0 and y == 0 and z == 0 then
				for x = minp.x, maxp.x do
					local index = area:index(x, y, z)
					data[index] = grassdef
				end
			end
		end
	end
	vm:set_data(data)
	vm:write_to_map()
	vm:update_map()
end)
---[[

-- Function to be executed on spawn
local function onSpawn(player)
	local pos = {x = 0.0, y = 0, z = 0.0} --player:get_pos()

	-- Print the player's position
	--c.log("Player spawned at position: x=" .. pos.x .. ", y=" .. pos.y .. ", z=" .. pos.z)

	-- Check and replace node at (0, 0, 0)
	local dirtname = minetest.get_name_from_content_id( minetest.get_content_id("mapgen_dirt_with_grass"))
	local spawnnode = minetest.get_node(pos)
	local spawnnodedef = minetest.registered_nodes[spawnnode.name]
	if spawnnodedef and spawnnodedef.air_equivalent  then
		minetest.set_node(pos, {name = dirtname})
	end
	--set spawn
	player:set_pos({x = 0.0, y = 1.5, z = 0.0})
	return true --returns true from function to disable regular player placement
end


-- Call function when player spawns or respawns
minetest.register_on_respawnplayer(onSpawn)
minetest.register_on_joinplayer(function(player)
	minetest.after(1, function()
			onSpawn(player)
	end)
end) -- i hate that is a thing, TODO: fix this

--log info about air?
minetest.register_on_mods_loaded(function()
	local air_node = minetest.registered_nodes["air"]
	if air_node then
		for key, value in pairs(air_node) do
			--c.log(key, ":", value)
		end
	else
		c.log("Node 'air' not found, the fuck did you do to the state?")
	end
end)

--]]