-- Initialize mod storage
-- ASLP (Anti Stupid Lua Polyfill)
local DIR_DELIM = DIR_DELIM or "/"
-- Engine headers
local MODPACK = debug.getinfo(1, "S").source:match("mods[/\\][/\\]?[^/\\]*"):match("[/\\].*$"):sub(2)
local MODNAME = minetest and minetest.get_current_modname() or MODPACK
local MODPATH = minetest and minetest.get_modpath(MODPACK) or debug.getinfo(1, "S").source:match("^(.+)[/\\]"):sub(2)
--locals
--Avoid Using $.get() to get null instead of sane defaults. 
local function nilget(key, default)
	if not minetest.settings:has(key) then 
		minetest.settings:set("noclip")
		
	else
		return nil
	end
end
--Avoid Using $.get() to get null instead of sane defaults. 
local function nilset(key, default)
	if not minetest.settings:has(key) then 
		--Race Condition?
		minetest.settings:set(key, default)
	else
		return nil
	end
end

-- Nooo! "Attempted to set secure setting."
-- nilset("secure.trusted_mods", "formspec_edit,")
	






--	At this distance the server will aggressively optimize which blocks are sent to
--	clients.
--	Small values potentially improve performance a lot, at the expense of visible
--	rendering glitches (some blocks will not be rendered under water and in caves,
--	as well as sometimes on land).
--	Setting this to a value greater than max_block_send_distance disables this
--	optimization.
--	Stated in mapblocks (16 nodes).
--	type: int min: 2 max: 32767
--nilset(" block_send_optimize_distance", 32767)
	



--	If enabled, the server will perform map block occlusion culling based on
--	on the eye position of the player. This can reduce the number of blocks
--	sent to the client by 50-80%. Clients will no longer receive most
--	invisible blocks, so that the utility of noclip mode is reduced.
--	type: bool
--nilset(" server_side_occlusion_culling", "true")
