local context = debug and debug.getinfo(1, "S").source:match("mods[/\\][/\\]?([^/]*)") or error("They broke debug!")

-- core: /usr/share/games/core/builtin/game/chat.lua
local S = core.get_translator("__builtin")
--local T = core.get_translator("")
--core.unregister_chatcommand("kill")
local handle_kill_command = core.registered_chatcommands["kill"].func
core.override_chatcommand("kill", {
	params = S("[<name>]"),
	description = S("Kill player or yourself"),
	privs = {server=false},
	func = function(name, param)
		if param == ""  or param == name  or core.get_player_privs(name).server then
			return handle_kill_command(name, param)
		else
			return false, "You don't have permission to run this command (missing privileges: server)."
		end
		--return handle_kill_command(name, param == "" and name or param)
	end,
})


local handle_giveme_command = core.registered_chatcommands["giveme"].func
core.override_chatcommand("giveme", {
	params = S("<ItemString> [<count> [<wear>]]"),
	description = S("Give item to yourself"),
	privs = {give=not core.is_singleplayer()},
	func = function(name, param)
			local par=param:split(" ")
			if #par >=1 and not par[1]:startsWith("mapgen_") and core.registered_aliases["mapgen_"..par[1]] then
				par[1]="mapgen_"..par[1]
				param=table.concat(par, " ")
			end
		return handle_giveme_command(name, param)
	end,
})

local handle_give_command = core.registered_chatcommands["give"].func
core.override_chatcommand("give", {
	params = S("<name> <ItemString> [<count> [<wear>]]"),
	description = S("Give item to player"),
	privs = {give=not core.is_singleplayer()},
	func = function(name, param)
			local par=param:split(" ")
			if #par >=2 and not par[2]:startsWith("mapgen_") and core.registered_aliases["mapgen_"..par[2]] then
				par[2]="mapgen_"..par[2]
				param=table.concat(par, " ")
			end
		return handle_give_command(name, param)
	end,
})


core.register_chatcommand("clear", {
	params = "",
	description = "clear screen",
	privs = {},
	func = function(name, param)
		local count = 0
		repeat
			count = count + 1
			minetest.chat_send_player(name, " ")
		until count >= 20
	end,
})
core.register_chatcommand("cls", {
	params	  = core.registered_chatcommands["clear"].params,
	description = core.registered_chatcommands["clear"].description,
	privs	   = core.registered_chatcommands["clear"].privs,
	func		= core.registered_chatcommands["clear"].func,
})


core.register_chatcommand("items", {
	params = "[metadata]",
	description = "list all items or items with metadata",
	privs = {},
	func = function(name, param)
		local items = {}
		local nodes = minetest.registered_nodes

		-- Populate the items table with all registered items
		for name, def in pairs(minetest.registered_items) do
			items[name] = def
		end

		-- Remove entries that are also in the nodes list
		for name in pairs(nodes) do
			items[name] = nil
		end

		-- Print the remaining items
		for itemname, def in pairs(items) do
			minetest.chat_send_player(name, "Registered item: " .. itemname)
		end
end
})
core.register_chatcommand("nodes", {
	params = "[metadata]",
	description = "list all items or items with metadata",
	privs = {},
	func = function(name, param)
		for item, def in pairs(minetest.registered_nodes) do
			minetest.chat_send_player(name, "Registered node: " .. item)
		end
	end
})

core.register_chatcommand("biomes", {
	params = "[metadata]",
	description = "list all items or items with metadata",
	privs = {},
	func = function()
 		local biomes = minetest.registered_biomes
 	   	for name, biome in pairs(biomes) do
			print("Biome name: " .. name)
		end
	end
})

