--Code that modifies information about player including: health totals, movement speeds, and more.
--movment world combat building 
--player combat world




local physics_override = {
gravity=1,  				-- default is 1.0
jump=1,						-- default is 1.0
speed=1.5,					-- default is 2.0
speed_sprint = 2,
speed_climb=2,				-- default is 1.0
speed_crouch=2,				-- default is 1.0
acceleration_air=1,			-- default is 1.0
acceleration_default=1,		-- default is 1.0
liquid_fluidity=1,			-- default is 1.0
liquid_fluidity_smooth=1,	-- default is 1.0
liquid_sink=1,				-- default is 1.0
new_move=true,				-- default is true
sneak=true,					-- default is true
sneak_glitch=true,			-- default is false
}
-- Register a globalstep callback to check for sprinting, and sneaking, and regen health
local function for_each_player(dtime)
	for _, player in ipairs(minetest.get_connected_players()) do
		player:set_physics_override(physics_override)
		local controls = player:get_player_control()
		if not controls.aux1 then  -- 'aux1' is the default sprint key
			--c.log("slow", physics_override.speed)
			player:set_physics_override({speed = physics_override.speed})  -- Normal speed
		else
			--c.log("fast", physics_override.sprint)
			player:set_physics_override({speed = physics_override.speed_sprint})  -- Increased speed
		end
		if not controls.sneak then  -- but 'sneak' can have a normal name... you know what whatever!
		else
		end
	end
end

minetest.register_globalstep(for_each_player)


--[[
local function remove_fall_damage()
	for _, player in ipairs(minetest.get_connected_players()) do
		player:set_armor_groups({fall_damage= 0})
	end 
	
end
--]]

local print_physics_command ={
	description = "Prints the player's physics override settings to the log",
	func = function(name)
		local player = minetest.get_player_by_name(name)
		if player then
			local physics = player:get_physics_override()
			for key, value in pairs(physics) do 
				minetest.log(tostring(key).."="..tostring(value))
			end
		else
			return false, "Player not found."
		end
	end
}
--minetest.register_chatcommand("print_physics", print_physics_command)
minetest.register_chatcommand("dodmg", 

{
	description = "Does damage to the player",
	func = function(name)
		local player = minetest.get_player_by_name(name)
		

	end
}

)

