#!/bin/sh
# simple integration test

CFG=/tmp/minetest.conf
MTDIR=/tmp/mt
WORLDDIR=${MTDIR}/worlds/world

cat <<EOF > ${CFG}
 enable_xp_redo_integration_test = true
EOF

mkdir -p ${WORLDDIR}/worldmods
git clone --depth=1 https://github.com/minetest-mods/areas ${WORLDDIR}/worldmods/areas

chmod 777 ${MTDIR} -R
docker run --rm -it \
	-v ${CFG}:/etc/minetest/minetest.conf:ro \
	-v ${MTDIR}:/var/lib/minetest/.minetest \
	-v $(pwd):/var/lib/minetest/.minetest/worlds/world/worldmods/epic \
	registry.gitlab.com/minetest/minetest/server:5.0.1

test -f ${WORLDDIR}/integration_test.json && exit 0 || exit 1
