--[[

		MTEngine_Stats
		=================================
		Basic Staticts of Minetest Engine

		Copyright (C) 2023-2025 mtvisitor and contributors.

		Licensed under the zlib license. See LICENSE.md for more information.

		History:
		2023-12-12  v0.1  init version
		2024-08-14	v0.2  released version

--]]

mtengine_stats = {}
mtengine_stats.version = 0.2

-- mte_stats.S = minetest.get_translator("mte_stats")
-- mte_stats.S = minetest.get_translator(minetest.get_current_modname())
mtengine_stats.S = minetest.get_current_modname()

local MP = minetest.get_modpath("mtengine_stats")
-- local WMP = minetest.get_worldpath()

dofile(MP .. "/config.lua")
dofile(MP .. "/common.lua")

-- 1）prepare local data

local local_debugging = true
local local_mod_name = minetest.get_current_modname()

local local_formspec_name = local_mod_name..":mtengine_stats"

local local_formspec_escape = minetest.formspec_escape
-- local local_mod_datapath = minetest.get_worldpath()..DIR_DELIM..local_mod_name..DIR_DELIM

local mtengine_stats_data_template = {
	player_name = "",
	stats_level = 58,
	project_name = "",
	project_version = "",
	lua_version = "",

	mtengine_license = "zLib/BSD3/MIT/Apache2/LGPL",
	mtengine_content = "CC BY-SA 4.0/CC BY-NC-SA 4.0",
	mtengine_release_date = "2023/12/04",
	project_build_date = "2023/12/10"
}

local local_mtengine_stats_data = nil

local local_minetest_version = minetest.get_version()

local local_mtengine_version_number = mtengine_stats.version_to_number(local_minetest_version.string)

-- mtengine_stats.MTEngine_Log("action", "mtengine_version:%s", local_minetest_version.string)
-- mtengine_stats.MTEngine_Log("action", "mtengine_version:%d", local_mtengine_version_number)

if local_mtengine_version_number < 50800 then
	error("mtengine_stats requires minetest engine version 5.8 or above!")
	return
end 

-- 2) get engine information
local function get_mtengine_stats(mtplayer_name, params)
--	local target_stats_level = params:trim()
	local stats_level_number = tonumber(mtengine_stats.config.mtengine_stats_level)

-- mtengine_stats.MTEngine_Log("action", "stats_level_number:%d", stats_level_number)	

	if stats_level_number >= 58 then

		local_mtengine_stats_data = table.copy(mtengine_stats_data_template)

		local_mtengine_stats_data.player_name = mtplayer_name
		local_mtengine_stats_data.stats_level = stats_level_number
		local_mtengine_stats_data.project_name = local_minetest_version.project
		local_mtengine_stats_data.project_version = local_minetest_version.string
		local_mtengine_stats_data.lua_version = _VERSION

		local_mtengine_stats_data.project_name = local_mtengine_stats_data.project_name.." (Engine) customized on ver " .. local_minetest_version.string	
	else
		local_mtengine_stats_data = nil

		mtengine_stats.MTEngine_Log("action", "mtengine_stats_level:%d(must >= 58)", stats_level_number)
		mtengine_stats.MTEngine_ChatLog("mtengine_stats_level:%d(must >= 58)", stats_level_number)			
	end

--	mtengine_stats.MTEngine_Log("action", "target_stats_level:%s", target_stats_level)
--	mtengine_stats.MTEngine_ChatLog("target_stats_level:%s", target_stats_level)	
end


-- 3) prepare to show engine information
local function get_formspec(mtplayer_name)
	local formspec = {
		"formspec_version[1]",
		"size[12,8]",
		"label[1,1;"..local_formspec_escape(mtplayer_name.."'s MTEngine Basic Stats (Level:")..local_mtengine_stats_data.stats_level..")]",
--			"label[1,2;"..local_formspec_escape("Player name: "..mte_stats.player_name).."]",
--			"label[1,2;"..local_formspec_escape("Stats level: "..mte_stats.stats_level).."]",
		"label[1,2;"..local_formspec_escape("Project name: "..local_mtengine_stats_data.project_name).."]",
		"label[1,3;"..local_formspec_escape("Project version: "..local_mtengine_stats_data.project_version).."]",
		"label[1,3.5;"..local_formspec_escape("Lua version: "..local_mtengine_stats_data.lua_version).."]",
--			"label[1,6;"..local_formspec_escape("License(s): "..local_mtengine_stats_data.mtengine_license).."]",
--			"label[1,7;"..local_formspec_escape("Content(s): "..local_mtengine_stats_data.mtengine_content).."]",
		"label[1,6.5;"..local_formspec_escape("MTEngine Release Date: "..local_mtengine_stats_data.mtengine_release_date).."]",
		"label[1,7;"..local_formspec_escape("Local Build Date: "..local_mtengine_stats_data.project_build_date).."]",			
--			"button[1,8;20,10;btn_ok;OK"
	}
    -- table.concat is faster than string concatenation - `..`
    return table.concat(formspec, "")		
end

local function show_mtengine_stats(mtplayer_name, params)

	get_mtengine_stats(mtplayer_name, params)	

	if local_mtengine_stats_data ~= nil then
--		mtengine_stats.MTEngine_ChatLog("get local_mtengine_stats_data successfully!")	
		
		minetest.show_formspec(mtplayer_name, local_formspec_name, get_formspec(mtplayer_name))			

		mtengine_stats.MTEngine_ChatLog("show mtengine_stats data successfully!")	

	end
end

-- 4) register chat command
minetest.register_chatcommand("mtengine_stats", {
	description = "Shows minetest engine Basic stats.",
	privs = { interact = true },
	params = "[mtengine_stats_level]",
	func = show_mtengine_stats
})

-- 5) print mod loaded information
-- print the mod loaded information in the console.
print ("[Console][MOD] MTEngine Stats Loaded!")
-- print some log information when the mod was loaded.
mtengine_stats.MTEngine_Log("action", "[MOD] MTEngine Stats Loaded!")

