--[[
	MTEngine Stats: common functions handling

	Copyright © 2023-2025 mtvisitor and contributors.
	Licensed under the zlib license. See LICENSE.md for more information.

--]]

mtengine_stats.common = {}

-- mte_stats.common.modname = mte_stats.S

local mod_name = minetest.get_current_modname()

function mtengine_stats.MTEngine_Get_timestamp()
	return os.time(os.date("!*t"))
end

function mtengine_stats.MTEngine_Log(level, message, ...)
	return minetest.log(level, ("[%s] %s"):format("MTEngine Stats", message:format(...)))
--	return minetest.log(level, ("[%s] %s"):format(mte_stats.common.modname, message:format(...)))
end

function mtengine_stats.MTEngine_ChatLog(message, ...)
	return minetest.chat_send_all(("Send All: [%s] %s"):format("MTEngine Stats", message:format(...)))
end

function mtengine_stats.version_to_number(version_str)
    local parts = {}
    for part in string.gmatch(version_str, "%d+") do
        table.insert(parts, part)
    end
    local major = tonumber(parts[1])
    local minor = tonumber(parts[2])
    local patch = tonumber(parts[3]) or 0
    return major * 10000 + minor * 100 + patch
end