--[[
	MTEngine Stats: configuration handling

	Copyright © 2023-2025 mtvisitor and contributors.
	Licensed under the zlib license. See LICENSE.md for more information.
--]]

mtengine_stats.config = {}

local function getint_default(setting, default)
	local value = minetest.settings:get(setting)
	if value == nil then
		value = default
	end
	return value
end

local function setting(settingtype, name, default)
	if settingtype == "int" then
		mtengine_stats.config[name] =
			getint_default("mtengine_stats." .. name, default)
	else
		mtengine_stats.config[name] =
			minetest.settings:get("mtengine_stats." .. name) or default
	end
end

-- get minetest.conf settings
setting("int", "mtengine_stats_level", 58)
