# Pedestals API

A thin wrapper around `radapi.register_pedestal` that provides sane defaults, smart table merging, and duplicate registration checks for Minetest pedestals.

## Features

*   **Sane Defaults**: Automatically applies standard `drawtype`, `paramtype2`, and groups to every pedestal.
*   **Smart Merging**: Correctly merges nested tables (such as `groups` and `tiles`) instead of overwriting them.
*   **Duplicate Prevention**: Logs a warning and prevents accidental overwrites if a pedestal is registered more than once.
*   **Consistency**: Ensures all pedestals share a consistent base definition.

## Dependencies

*   `radapi`

## Usage

To register a new pedestal, use the `pedestals_api.register_pedestal` function.

### Example

```lua
pedestals_api.register_pedestal("mymod", "gem_stand", {
    description = "Gem Display Stand",
    mesh        = "mymod_pedestal.obj",
    tiles       = {"mymod_stone.png"},
    -- These groups are merged with the defaults (radapi_display=1, etc.)
    groups      = {cracky = 3}, 
    display_offset = {x = 0, y = 0.8, z = 0},
    display_visual_size = {x = 0.5, y = 0.5},
})
```

### API Reference

#### `pedestals_api.register_pedestal(modname, name, def)`

*   **modname** (string): The name of the mod registering the pedestal.
*   **name** (string): The specific name of the pedestal. The resulting node name will be `modname:name`.
*   **def** (table): The node definition table.
