# Pedestals API

A thin wrapper around `radapi.register_pedestal` that provides sane defaults, smart table merging, and duplicate registration checks for Minetest pedestals. This version is fully optimized for **RADAPI v2.1.0**.

## Features

* **Sane Defaults**: Automatically applies standard `drawtype`, `paramtype2`, and required visual groups to every pedestal.
* **Smart Merging**: Correctly merges nested tables (such as `groups` and `tiles`) so you can add properties without losing the base functionality.
* **Automatic Key Mapping**: Automatically maps legacy `display_offset` keys to the new `display_offset_value` used in RADAPI v2.1.0.
* **Duplicate Prevention**: Logs a warning and prevents accidental overwrites if a pedestal name is already taken.
* **Display Restoration**: Leverages RADAPI’s LBM system to ensure displayed items are restored instantly when a map block loads.

## Dependencies

* `radapi` (v2.1.0 or higher recommended)

## Usage

To register a new pedestal, use the `pedestals_api.register_pedestal` function. It handles the complicated node properties so you only have to focus on the visuals.

### Example

```lua
pedestals_api.register_pedestal("mymod", "gem_stand", {
    description = "Gem Display Stand",
    mesh        = "mymod_pedestal.obj",
    tiles       = {"mymod_stone.png"},
    -- These groups are merged with defaults (radapi_display=1, choppy=2, etc.)
    groups      = {cracky = 3}, 
    
    -- Positioning the displayed item
    display_offset_value = {x = 0, y = 0.8, z = 0},
    display_visual_size  = {x = 0.5, y = 0.5},
    
    -- Optional: Make the pedestal block itself glow
    light_source = 10,
})

```

### API Reference

#### `pedestals_api.register_pedestal(modname, name, def)`

* **modname** (string): The name of the mod registering the pedestal.
* **name** (string): The specific name of the pedestal. The resulting node name will be `modname:name`.
* **def** (table): The node definition table.
* Supports all standard Minetest node fields.
* Supports `display_offset_value` (vector) to position the floating item.
* Supports `display_visual_size` (vector) to scale the floating item.



---
