local pedestal_definitions = {}
local pedestal_registry    = {}
pedestals_api = {}

local default_pedestal = {
    drawtype   = "mesh",
    paramtype2 = "facedir",
    groups = {
        radapi_display          = 1,
        choppy                  = 2,
        oddly_breakable_by_hand = 2,
    },
    display_offset_value = {x = 0, y = 0.5, z = 0}, 
    display_visual_size  = {x = 0.75, y = 0.75},
}

-------------------------------------------------------------------------------
-- Utility helpers
-------------------------------------------------------------------------------
local function deepcopy(orig)
    if type(orig) ~= "table" then return orig end
    local copy = {}
    for k, v in pairs(orig) do
        copy[k] = deepcopy(v)
    end
    return copy
end

local function merge_tables(dest, src)
    for k, v in pairs(src) do
        if type(v) == "table" and type(dest[k]) == "table" then
            merge_tables(dest[k], v)
        else
            dest[k] = v
        end
    end
end

-------------------------------------------------------------------------------
-- Pedestal registration
-------------------------------------------------------------------------------
function pedestals_api.register_pedestal(modname, name, def)
    local full_name = modname .. ":" .. name
    
    if pedestal_registry[full_name] then
        core.log("warning", "[pedestals_api] Duplicate pedestal registration: " .. full_name)
        return false
    end

    local node_def = deepcopy(default_pedestal)
    merge_tables(node_def, def)

    pedestal_definitions[full_name] = node_def
    
    radapi.register_pedestal(modname, name, node_def)
    
    pedestal_registry[full_name] = true
    return true
end