## Index

## Core Registration

### `pedestals_api.register_pedestal(name, def)`

Registers a new pedestal node and its associated display entity logic.

**Example:**

```lua
pedestals_api.register_pedestal("mymod:basic_stand", {
    description = "Oak Pedestal",
    tiles = {"default_wood.png"},
})

```

---

## Configuration Table (def)

### Display Settings

These properties control the appearance of the item sitting on the pedestal.

| Property | Type | Default | Description |
| --- | --- | --- | --- |
| `visual_size` | number | `0.667` | Scale of the displayed item. |
| `glow` | number | `0` | Brightness of the item (0-14). Useful for magical items. |

**Example:**

```lua
visual_size = 1.0, -- Make the item full-sized
glow = 14,         -- Make the item glow brightly in the dark

```

### Animation Settings

The API allows for automated movements of the displayed item without extra code.

| Property | Type | Default | Description |
| --- | --- | --- | --- |
| `bobbing` | boolean | `false` | If `true`, the item floats up and down smoothly. |
| `spin_speed` | number | `0` | Rotation speed. Higher numbers are faster. |
| `spin_direction` | string | `"y"` | The axis to spin on. Can be `"x"`, `"y"`, or `"z"`. You can combine them like `"xyz"`. |

**Example:**

```lua
bobbing = true,
spin_speed = 2.0,
spin_direction = "y", -- Item spins like a trophy

```

### Positioning Settings

Fine-tune where and how the item is oriented when it is first placed.

| Property | Type | Default | Description |
| --- | --- | --- | --- |
| `rotation_offset` | table | `{x=0,y=0,z=0}` | The initial static rotation (in degrees) of the item. |
| `directional_offset` | table | `{x=0,y=0,z=0}` | Adjusts the XYZ position of the item relative to the top of the node. |

**Example:**

```lua
rotation_offset = {x=45, y=0, z=0}, -- Tilt the item forward
directional_offset = {x=0, y=0.5, z=0}, -- Lift the item higher off the base

```

### Node Definition

The pedestal itself is a Minetest node. You can customize its physical form.

| Property | Type | Default | Description |
| --- | --- | --- | --- |
| `description` | string | `"Pedestal"` | The name shown to players. |
| `tiles` | table | `{"blank.png"}` | Textures for the pedestal block. |
| `mesh` | string | `nil` | Optional: Use an `.obj` or `.b3d` file for the pedestal shape. |
| `nodebox` | table | `fixed...` | Custom collision/selection box if not using a mesh. |
| `groups` | table | `{cracky=3...}` | Standard Minetest groups for mining/breaking. |

---

## Callbacks

Callbacks allow you to run custom code when a player interacts with the pedestal.

### `_after_placed(pos, itemstring, placer)`

Called immediately after a player places an item into the pedestal.

* `pos`: Vector position of the pedestal.
* `itemstring`: The name of the item (e.g., `"default:dirt"`).
* `placer`: The player ObjectRef.

### `_after_takeout(pos, itemstring, clicker)`

Called immediately after a player takes the item back.

**Example:**

```lua
_after_placed = function(pos, item, player)
    core.log("action", player:get_player_name() .. " placed " .. item .. " at " .. core.pos_to_string(pos))
end

```

---

## Crafting

### `recipe`

If you include a `recipe` field in the `def` table, the API will automatically register the craft for you.

**Example:**

```lua
recipe = {
    {"default:stone", "default:stone", "default:stone"},
    {"", "default:stone", ""},
    {"default:stone", "default:stone", "default:stone"},
}

```
