# Pedestals API 

A powerful and flexible API to create pedestal nodes that can display items with custom animations (bobbing, spinning) and dynamic light effects.

---

## Features

* **Item Display:** Uses entities to show items in high fidelity.
* **Dynamic Lighting:** Define specific items that emit light when placed on a pedestal.
* **Animations:** Built-in support for bobbing (floating) and rotation (spinning) on any axis.
* **Automatic Cleanup:** Automatically handles item drops and entity removal when pedestals are dug.
* **Crafting Integration:** Register recipes directly within the pedestal definition.

---

## API Usage: `pedestals_api.register_pedestal`

To create a new pedestal, call `pedestals_api.register_pedestal(name, definition)`.

### Registration Skeleton

```lua
pedestals_api.register_pedestal("mymod:obsidian_pedestal", {
    -- 1. Basic Node Info
    description = "Obsidian Display Pedestal",
    tiles = {"default_obsidian.png"},
    groups = {cracky = 1, level = 2},
    
    -- 2. Crafting Recipe (Optional)
    recipe = {
        {"default:obsidian", "default:obsidian", "default:obsidian"},
        {"",                 "default:obsidian", ""                },
        {"default:obsidian", "default:obsidian", "default:obsidian"},
    },

    -- 3. Visual Shape (Standard Nodebox)
    nodebox = {
        type = "fixed",
        fixed = {{-0.33, -0.5, -0.33, 0.33, 0.5, 0.33}}
    },

    -- 4. Item Display Settings
    visual_size = 0.667,           -- Scale of the displayed item
    glow = 5,                      -- Internal entity glow (0-14)
    directional_offset = {x=0, y=0.1, z=0}, -- Fine-tune item position
    rotation_offset = {x=0, y=0, z=0},      -- Initial rotation in degrees

    -- 5. Animation Settings
    bobbing = true,                -- Floating animation up/down
    spin_speed = 1.0,              -- Rotation speed (radians per second)
    spin_direction = "y",          -- Axis to spin on: "x", "y", "z", or "xyz"

    -- 6. Light Interaction
    -- Define items that cast light when placed on this specific pedestal
    light_items = {
        ["default:torch"] = {radius = 3, level = 12},
        ["default:meselamp"] = {radius = 5, level = 14},
    }
})

```

---

## Configuration Options

| Option | Type | Default | Description |
| --- | --- | --- | --- |
| `description` | String | `"Pedestal"` | The tooltip shown to players. |
| `tiles` | Table | `{"blank.png"}` | The textures for the pedestal node. |
| `recipe` | Table | `nil` | A 3x3 grid for the crafting recipe. |
| `nodebox` | Table | (Fixed) | The physical shape of the pedestal. |
| `groups` | Table | `{cracky=3...}` | Standard Minetest node groups. |
| `visual_size` | Number | `0.667` | Scale multiplier for the displayed item. |
| `glow` | Number | `0` | How much the displayed entity glows. |
| `directional_offset` | Vector | `{0,0,0}` | Fine-tune the height/position of the item. |
| `rotation_offset` | Table | `{0,0,0}` | The base rotation in degrees. |
| `bobbing` | Boolean | `false` | Enables floating up/down animation. |
| `spin_speed` | Number | `0` | Rotation speed in radians per second. |
| `spin_direction` | String | `"y"` | The axis for rotation (`"x"`, `"y"`, or `"z"`). |
| `light_items` | Table | `{}` | Map of item names to `{radius, level}` light configs. |

---

## Internal Light System

The API includes a specialized light manager to handle "virtual" light sources without creating flickering or node-swapping conflicts.

* **`pedestals_api.add_area_light(pos, radius, level)`**: Places invisible light nodes. Returns a unique ID.
* **`pedestals_api.remove_area_light(id)`**: Cleans up the light nodes and restores the previous map state.

---

## Interaction Logic

* **Right-Click:** If the pedestal is empty, it takes one item from your hand. If it holds an item, it returns it to your inventory (or drops it if your inventory is full).
* **Protection:** Items cannot be placed or removed if the area is protected by another player.
* **Creative Mode:** In creative mode, items are not consumed when placed and are not given back when removed to prevent infinite item generation.
