local FUNCTIONS = {}

FUNCTIONS.UUID = 0

function FUNCTIONS.deepcopy(orig, copies)
    copies = copies or {}
    local orig_type = type(orig)
    if orig_type == 'table' then
        if copies[orig] then return copies[orig] end
        local copy = {}
        copies[orig] = copy
        for orig_key, orig_value in next, orig, nil do
            copy[orig_key] = FUNCTIONS.deepcopy(orig_value, copies)
        end
        local mt = getmetatable(orig)
        if mt then
            setmetatable(copy, FUNCTIONS.deepcopy(mt, copies))
        end
        return copy
    else
        return orig
    end
end

function FUNCTIONS.merge_properties(base, override)
    if not override then
        local copy = {}
        for k, v in pairs(base) do
            if type(v) == "table" then
                copy[k] = FUNCTIONS.merge_properties(v, nil)
            else
                copy[k] = v
            end
        end
        return copy
    end

    local props = {}
    for k, v in pairs(base) do
        if type(v) == "table" then
            props[k] = FUNCTIONS.merge_properties(v, nil)
        else
            props[k] = v
        end
    end

    for k, v in pairs(override) do
        if type(v) == "table" and type(props[k]) == "table" then
            props[k] = FUNCTIONS.merge_properties(props[k], v)
        else
            props[k] = v
        end
    end

    return props
end

function FUNCTIONS.gen_uuid()
    FUNCTIONS.UUID = FUNCTIONS.UUID + 1
    return os.time() .. "-" .. tostring(FUNCTIONS.UUID)
end

local entity_uuid_map = setmetatable({}, {__mode = "k"})

function FUNCTIONS.get_target_key(target)
    if not target then return nil end

    if target:is_player() then
        return "player_" .. target:get_player_name()
    elseif target:get_luaentity() then
        if not entity_uuid_map[target] then
            entity_uuid_map[target] = FUNCTIONS.gen_uuid()
        end
        
        return "object_" .. entity_uuid_map[target]
    else
        return nil
    end
end
local entity_references = setmetatable({}, {__mode = "v"})  -- Weak values

function FUNCTIONS.store_entity_reference(key, entity)
    entity_references[key] = entity
end

function FUNCTIONS.get_entity_reference(key)
    return entity_references[key]
end

function FUNCTIONS.remove_entity_reference(key)
    local entity = entity_references[key]
    if entity and entity:get_luaentity() then
        entity:remove()
    end
    entity_references[key] = nil
end

return FUNCTIONS