--[[
=====================================================================
** More Ores **
By Calinou, with the help of Nore.

** Kitty/Kitto Ores and tools **
Used more ores mod as base of this pack. all rights belong
to their respectful owners.

Copyright Ã‚Â© 2011-2020 Hugo Locurcio and contributors.
No copyright 2021 Nemokitty9
Licensed under the zlib license. See LICENSE.md for more information.
=====================================================================
--]]

kitores = {}

local modpath = minetest.get_modpath("kitores")

local S = minetest.get_translator("kitores")
kitores.S = S

dofile(modpath .. "/_config.txt")

-- `mg` mapgen support
if minetest.get_modpath("mg") then
	dofile(modpath .. "/mg.lua")
end

-- `frame` support
local use_frame = minetest.get_modpath("frame")

local default_stone_sounds = default.node_sound_stone_defaults()
local default_metal_sounds = default.node_sound_metal_defaults()

-- Returns the crafting recipe table for a given material and item.
local function get_recipe(material, item)
	if item == "sword" then
		return {
			{material},
			{material},
			{"group:stick"},
		}
	end
	if item == "shovel" then
		return {
			{material},
			{"group:stick"},
			{"group:stick"},
		}
	end
	if item == "axe" then
		return {
			{material, material},
			{material, "group:stick"},
			{"", "group:stick"},
		}
	end
	if item == "pick" then
		return {
			{material, material, material},
			{"", "group:stick", ""},
			{"", "group:stick", ""},
		}
	end
	if item == "block" then
		return {
			{material, material, material},
			{material, material, material},
			{material, material, material},
		}
	end
	if item == "lockedchest" then
		return {
			{"group:wood", "group:wood", "group:wood"},
			{"group:wood", material, "group:wood"},
			{"group:wood", "group:wood", "group:wood"},
		}
	end
end

local function add_ore(modname, description, mineral_name, oredef)
	local img_base = modname .. "_" .. mineral_name
	local toolimg_base = modname .. "_tool_"..mineral_name
	local tool_base = modname .. ":"
	local tool_post = "_" .. mineral_name
	local item_base = tool_base .. mineral_name
	local ingot = item_base .. "_ingot"
	local lump_item = item_base .. "_lump"

	if oredef.makes.ore then
		minetest.register_node(modname .. ":mineral_" .. mineral_name, {
			description = S("@1 Ore", S(description)),
			tiles = {"default_stone.png^" .. modname .. "_mineral_" .. mineral_name .. ".png"},
			groups = {cracky = 2},
			sounds = default_stone_sounds,
			drop = lump_item,
		})

		if use_frame then
			frame.register(modname .. ":mineral_" .. mineral_name)
		end
	end

	if oredef.makes.block then
		local block_item = item_base .. "_block"
		minetest.register_node(block_item, {
			description = S("@1 Block", S(description)),
			tiles = {img_base .. "_block.png"},
			groups = {snappy = 1, bendy = 2, cracky = 1, melty = 2, level = 2},
			sounds = default_metal_sounds,
		})
		minetest.register_alias(mineral_name.."_block", block_item)
		if oredef.makes.ingot then
			minetest.register_craft( {
				output = block_item,
				recipe = get_recipe(ingot, "block")
			})
			minetest.register_craft( {
				output = ingot .. " 9",
				recipe = {
					{block_item},
				}
			})
		end
		if use_frame then
			frame.register(block_item)
		end
	end

	if oredef.makes.lump then
		minetest.register_craftitem(lump_item, {
			description = S("@1 Lump", S(description)),
			inventory_image = img_base .. "_lump.png",
		})
		minetest.register_alias(mineral_name .. "_lump", lump_item)
		if oredef.makes.ingot then
			minetest.register_craft({
				type = "cooking",
				output = ingot,
				recipe = lump_item,
			})
		end
		if use_frame then
			frame.register(lump_item)
		end
	end

	if oredef.makes.ingot then
		minetest.register_craftitem(ingot, {
			description = S("@1 Ingot", S(description)),
			inventory_image = img_base .. "_ingot.png",
		})
		minetest.register_alias(mineral_name .. "_ingot", ingot)
		if use_frame then
			frame.register(ingot)
		end
	end

	if oredef.makes.chest then
		minetest.register_craft( {
			output = "default:chest_locked",
			recipe = {
				{ingot},
				{"default:chest"},
			}
		})
		minetest.register_craft( {
			output = "default:chest_locked",
			recipe = get_recipe(ingot, "lockedchest")
		})
	end

	oredef.oredef.ore_type = "scatter"
	oredef.oredef.ore = modname .. ":mineral_" .. mineral_name
	oredef.oredef.wherein = "default:stone"

	minetest.register_ore(oredef.oredef)

	for tool_name, tooldef in pairs(oredef.tools) do
		local tdef = {
			description = "",
			inventory_image = toolimg_base .. tool_name .. ".png",
			tool_capabilities = {
				max_drop_level = 3,
				groupcaps = tooldef,
			},
			sound = {breaks = "default_tool_breaks"},
		}

		if tool_name == "sword" then
			tdef.tool_capabilities.full_punch_interval = oredef.full_punch_interval
			tdef.tool_capabilities.damage_groups = oredef.damage_groups
			tdef.description = S("@1 Sword", S(description))
		end

		if tool_name == "pick" then
			tdef.tool_capabilities.full_punch_interval = oredef.full_punch_interval
			tdef.tool_capabilities.damage_groups = oredef.damage_groups
			tdef.description = S("@1 Pickaxe", S(description))
		end

		if tool_name == "axe" then
			tdef.tool_capabilities.full_punch_interval = oredef.full_punch_interval
			tdef.tool_capabilities.damage_groups = oredef.damage_groups
			tdef.description = S("@1 Axe", S(description))
		end

		if tool_name == "shovel" then
			tdef.full_punch_interval = oredef.full_punch_interval
			tdef.tool_capabilities.damage_groups = oredef.damage_groups
			tdef.description = S("@1 Shovel", S(description))
			tdef.wield_image = toolimg_base .. tool_name .. ".png^[transformR90"
		end

		local fulltool_name = tool_base .. tool_name .. tool_post

		if tool_name == "hoe" and minetest.get_modpath("farming") then
			tdef.max_uses = tooldef.uses
			tdef.description = S("@1 Hoe", S(description))
			farming.register_hoe(fulltool_name, tdef)
		end

		-- Hoe registration is handled above.
		-- There are no crafting recipes for hoes, as they have been
		-- deprecated from Minetest Game:
		-- https://github.com/minetest/minetest_game/commit/9c459e77a
		if tool_name ~= "hoe" then
			minetest.register_tool(fulltool_name, tdef)

			if oredef.makes.ingot then
				minetest.register_craft({
					output = fulltool_name,
					recipe = get_recipe(ingot, tool_name)
				})
			end
		end

		-- Toolranks support
		if minetest.get_modpath("toolranks") then
			minetest.override_item(fulltool_name, {
				original_description = tdef.description,
				description = toolranks.create_description(tdef.description, 0, 1),
				after_use = toolranks.new_afteruse})
		end

		minetest.register_alias(tool_name .. tool_post, fulltool_name)
		if use_frame then
			frame.register(fulltool_name)
		end
	end
end

local oredefs = {
	rude = {
		description = "Rude",
		makes = {ore = true, block = true, lump = true, ingot = true, chest = false},
		oredef = {
			clust_scarcity = kitores.rude_chunk_size ^ 2,
			clust_num_ores = kitores.rude_ore_per_chunk,
			clust_size = kitores.rude_chunk_size,
			y_min = kitores.rude_min_depth,
			y_max = kitores.rude_max_depth,
		},
		tools = {
			pick = {
				cracky = {times = {[1] = 1.60, [2] = 0.80, [3] = 0.20}, uses = 1000, maxlevel = 3},
			},
			hoe = {
				uses = 600,
			},
			shovel = {
				crumbly = {times = {[1] = 0.80, [2] = 0.20, [3] = 0.05}, uses = 400, maxlevel = 3},
			},
			axe = {
				choppy = {times = {[1] = 1.00, [2] = 0.40, [3] = 0.15}, uses = 800, maxlevel = 3},
				fleshy = {times = {[2] = 2.00, [3] = 0.80}, uses = 600, maxlevel = 1}
			},
			sword = {
				fleshy = {times = {[2] = 0.10, [3] = 0.08}, uses = 100, maxlevel = 3},
				snappy = {times = {[2] = 0.20, [3] = 0.15}, uses = 100, maxlevel = 1},
				choppy = {times = {[3] = 0.20}, uses = 100, maxlevel = 0},
			},
		},
		full_punch_interval = 1.0,
		damage_groups = {fleshy = 6},
	},
	ramenion = {
		description = "Ramenion",
		makes = {ore = true, block = true, lump = true, ingot = true, chest = false},
		oredef = {
			clust_scarcity = kitores.ramenion_chunk_size ^ 1,
			clust_num_ores = kitores.ramenion_ore_per_chunk,
			clust_size = kitores.ramenion_chunk_size,
			y_min = kitores.ramenion_min_depth,
			y_max = kitores.ramenion_max_depth,
		},
		tools = {
			pick = {
				cracky = {times = {[1] = 0.05, [2] = 0.03, [3] = 0.01}, uses = 2000, maxlevel = 4}
			},
			hoe = {
				uses = 1500,
			},
			shovel = {
				crumbly = {times = {[1] = 0.02, [2] = 0.01, [3] = 0.01}, uses = 1000, maxlevel = 4},
			},
			axe = {
				choppy = {times = {[1] = 0.05, [2] = 0.03, [3] = 0.01}, uses = 2000, maxlevel = 4},
				fleshy = {times = {[2] = 0.08, [3] = 0.06}, uses = 800, maxlevel = 2}
			},
			sword = {
				fleshy = {times = {[2] = 0.03, [3] = 0.01}, uses = 1000, maxlevel = 4},
				snappy = {times = {[2] = 0.06, [3] = 0.03}, uses = 560, maxlevel = 2},
				choppy = {times = {[3] = 0.65}, uses = 450, maxlevel = 3},
			},
		},
		full_punch_interval = 0.45,
		damage_groups = {fleshy = 9},
	}
}

-- If tin is available in the `default` mod, don't register More Ores' variant of tin
local default_tin
if minetest.registered_items["default:tin_ingot"] then
	default_tin = true
else
	default_tin = false
end

if default_tin then
	minetest.register_alias("kitores:mineral_tin", "default:stone_with_tin")
	minetest.register_alias("kitores:tin_lump", "default:tin_lump")
	minetest.register_alias("kitores:tin_ingot", "default:tin_ingot")
	minetest.register_alias("kitores:tin_block", "default:tinblock")
else
	oredefs.tin = {
		description = "Tin",
		makes = {ore = true, block = true, lump = true, ingot = true, chest = false},
		oredef = {
			clust_scarcity = kitores.tin_chunk_size ^ 3,
			clust_num_ores = kitores.tin_ore_per_chunk,
			clust_size = kitores.tin_chunk_size,
			y_min = kitores.tin_min_depth,
			y_max = kitores.tin_max_depth,
		},
		tools = {},
	}

	-- Bronze has some special cases, because it is made from copper and tin
	minetest.register_craft({
		type = "shapeless",
		output = "default:bronze_ingot 3",
		recipe = {
			"kitores:tin_ingot",
			"default:copper_ingot",
			"default:copper_ingot",
		},
	})
end

-- Copper rail (unique node)
if minetest.get_modpath("carts") then
	carts:register_rail("kitores:copper_rail", {
		description = S("Copper Rail"),
		tiles = {
			"moreores_copper_rail.png",
			"moreores_copper_rail_curved.png",
			"moreores_copper_rail_t_junction.png",
			"moreores_copper_rail_crossing.png",
		},
		inventory_image = "moreores_copper_rail.png",
		wield_image = "moreores_copper_rail.png",
		groups = carts:get_rail_groups(),
	}, {})
end

minetest.register_craft({
	output = "kitores:copper_rail 24",
	recipe = {
		{"default:copper_ingot", "", "default:copper_ingot"},
		{"default:copper_ingot", "group:stick", "default:copper_ingot"},
		{"default:copper_ingot", "", "default:copper_ingot"},
	},
})

for orename, def in pairs(oredefs) do
	-- Register everything
	add_ore("kitores", def.description, orename, def)
end
