# BlockWatch Mod for Minetest

BlockWatch is a Minetest mod designed to monitor and record block-related events in the game world. It provides features such as event logging, database statistics checking, and the ability to inspect data for a specific block.

## Features

- **Event Monitoring:** Record events like breaking or placing blocks by players.
- **Database Storage:** Store events in a database for later analysis.
- **Statistical Checking:** Use commands to check statistics for the events database.
- **Compatibility with Other Mods:** The mod can be extended to support other mod-specific events.

## Usage

To use BlockWatch, ensure players have the appropriate permissions to access commands. Refer to the [full documentation](<https://github.com/Neocraft1293/BlockWatch/wiki>) for detailed information on commands, item recipes, and mod configuration.

## Installation

1. Download the BlockWatch mod from the [releases page](<https://content.minetest.net/packages/neocraft1293/blockwatch/>) or clone the repository.
2. Place the mod folder in the `mods` directory of your Minetest game.
3. Configure the mod as needed (refer to the documentation).

## Commands

- `/events_stats`: Check statistics for the events database.
- `/check_block_data_blockwatch <x> <y> <z>`: Check data for a specific block at the given coordinates.
- `/reload_database_blockwatch`: Reload the events database.

## Contribution and Support

- **Contributing:** Feel free to contribute to the development by submitting issues, feature requests, or pull requests on the [GitHub project page](<https://github.com/Neocraft1293/BlockWatch>).
- **Support:** If you have questions or issues, please open a discussion on the [GitHub Issues](<https://github.com/Neocraft1293/BlockWatch/issues>).

## Authors

BlockWatch is developed by [neocraft1293](<https://github.com/Neocraft1293>).
