function remove_enchantments(itemstack)
    local meta = itemstack:get_meta()
    -- Supposons que les enchantements sont stockés sous une certaine clé dans les métadonnées, ici on réinitialise cette clé
    meta:set_string("enchantments", "")
    return itemstack
end

--tout ce qui est afficher dans le jeu doit être en anglais
local function calculate_pickaxe_level(itemstack, counter, levelofpickaxe, nameofuser)
    local level = 0
    local xp = 0
    
    -- Déterminer le multiplicateur XP basé sur le niveau de la pioche
    local xp_multipliers = {
        [1] = 1,    -- niveau 1 (pioche en bois)
        [2] = 0.5,  -- niveau 2 (pioche en pierre)
        [3] = 0.1,    -- niveau 3 (pioche en fer)
        [4] = 0.02,  -- niveau 4 (pioche en diamant)
        [5] = 0.005     -- niveau 5 (pioche en netherite)
    }
    
    -- Vérifier que levelofpickaxe est valide et obtenir le multiplicateur XP
    local multiplier = xp_multipliers[levelofpickaxe]
    if not multiplier then
       --minetest.chat_send_all("Niveau de pioche invalide: " .. tostring(levelofpickaxe))
        return level
    end
   --minetest.chat_send_all("Multiplicateur pour le niveau " .. tostring(levelofpickaxe) .. " : " .. multiplier)
    
    -- Calculer l'XP
    xp = counter * multiplier
   --minetest.chat_send_all("XP calculé : " .. xp)
    
    -- Envoyer des messages pour débogage
    local pickaxe_names = {
        [1] = "wooden pickaxe",
        [2] = "stone pickaxe",
        [3] = "iron pickaxe",
        [4] = "diamond pickaxe",
        [5] = "netherite pickaxe"
    }
   --minetest.chat_send_all(pickaxe_names[levelofpickaxe])
   --minetest.chat_send_all("counter: " .. counter)
    
    -- Calculer le niveau de la pioche
    local base_xp = 1000 -- xp de base pour atteindre le niveau 1
    if xp > 0 then
        level = math.floor(math.log(xp / base_xp + 1) * 21.7) -- formule ajustée pour calculer le niveau
    end
    
    -- Si le niveau calculé est inférieur à 1, on le met à 1
    if level < 1 then
        level = 1
    end
    --recupère l'usure maximale de l'outil avant qu'il ne se casse

    local tool_capabilities = itemstack:get_tool_capabilities()
    local original_wear = itemstack:get_wear()  -- récupérer l'usure actuelle de l'outil
    calcule26 = ((100-level)/100)*65535--calcule le pourcentage de l'usure
    if calcule26 < 1 then -- si l'usure est inférieur à 1 alors on met à 1
        calcule26 = 1 -- pour éviter les erreurs
    elseif calcule26 > 65535 then -- si l'usure est supérieur à 65535 alors on met à 65535
        calcule26 = 65535 -- pour éviter les erreurs
    end

    itemstack:set_wear(calcule26)  -- Appliquer la nouvelle usure à l'outil



   --minetest.chat_send_all("Niveau calculé : " .. level)

    -- si le niveau de la pioche est audessu 25 alors on lui donne un enchantement de efficacité 1
    if level == 15 then
        --verifie dans les metadata d l'itemstack si il est au niveau 25
        if itemstack:get_meta():get_int("level") == 15 then

        else
            --si non alors on met à jour les metadata de l'itemstack
            local meta = itemstack:get_meta()
            meta:set_int("level", 15)
            --envoire un message au joueur pour lui dire que la pioche est de niveau 15
            minetest.chat_send_player(nameofuser, "the pickaxe is now level 15!")
           --minetest.chat_send_all("La pioche est maintenant de niveau 15!")
           local enchantment = "efficiency"
           local enchantment_level = 1
           
           local can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
           if can_enchant then
               itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
               minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Efficiency 1!")
                meta:set_int("level", 15)
           else
               minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
           end
           

           --minetest.chat_send_all("La pioche a été enchantée avec Efficacité 1!")
        end
    elseif level == 25 then
        --verifie dans les metadata d l'itemstack si il est au niveau 25
        if itemstack:get_meta():get_int("level") == 25 then

        else
            --si non alors on met à jour les metadata de l'itemstack
            local meta = itemstack:get_meta()
            meta:set_int("level", 25)
            --envoire un message au joueur pour lui dire que la pioche est de niveau 25
            minetest.chat_send_player(nameofuser, "the pickaxe is now level 25!")
            --replace par une nouvelle pioche pour enlever les enchantements mais doit garder les metadata
            --recupère le counter de l'itemstack
            local counter = meta:get_int("counter")
            --recupère le niveau de l'itemstack
            local levelofpickaxe = meta:get_int("level")
            --recuper le niveau de la pioche dans le nom de l'item pour savoir quel pioche donner
            local levelofpickaxe = itemstack:get_name():sub(-1) -- récupère le dernier caractère du nom de l'item
            levelofpickaxe = tonumber(levelofpickaxe) -- convertit le caractère en nombre
            --remplace l'itemstack par une nouvelle pioche
            if levelofpickaxe == 1 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl2")
            elseif levelofpickaxe == 2 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl2")
            elseif levelofpickaxe == 3 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl3")
            elseif levelofpickaxe == 4 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl4")
            elseif levelofpickaxe == 5 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl5")
            end
            -- local my_item = ItemStack("some_item") my_item = remove_enchantments(my_item)
            --utilise la fonction remove_enchantments pour suprimmer les enchantements de la pioche
            local enchantments = mcl_enchanting.get_enchantments(itemstack)
            for _, enchantment in ipairs(enchantments) do
                itemstack = mcl_enchanting.remove_enchantment(itemstack, enchantment)
            end
            meta:set_int("counter", counter)
            --ajoute un enchantement de efficacité 2
            --suprimme les enchantements de la pioche
            local enchantments = mcl_enchanting.get_enchantments(itemstack)
            for _, enchantment in ipairs(enchantments) do
                itemstack = mcl_enchanting.remove_enchantment(itemstack, enchantment)
            end
           local enchantment = "efficiency"
           local enchantment_level = 2
           
           local can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
           if can_enchant then
               itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
               minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Efficiency 2!")
               meta:set_int("level", 25)
           else
               minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
           end
           

           --minetest.chat_send_all("La pioche a été enchantée avec Efficacité 2!")
        end
    elseif level == 50 then
        --verifie dans les metadata d l'itemstack si il est au niveau 50
        if itemstack:get_meta():get_int("level") == 50 then

        else --donne un enchantement de efficacité 3 et donne un enchantement de fortunne 1
            --envoire un message au joueur pour lui dire que la pioche est de niveau 50
            minetest.chat_send_player(nameofuser, "the pickaxe is now level 50!")
            --replace par une nouvelle pioche pour enlever les enchantements mais doit garder les metadata
            --recupère les metadata de l'itemstack
            local meta = itemstack:get_meta()
            --recupère le counter de l'itemstack
            local counter = meta:get_int("counter")
            --recupère le niveau de l'itemstack
            local levelofpickaxe = meta:get_int("level")
            --remplace l'itemstack par une nouvelle pioche
            --recuper le niveau de la pioche dans le nom de l'item pour savoir quel pioche donner
            local levelofpickaxe = itemstack:get_name():sub(-1) -- récupère le dernier caractère du nom de l'item
            levelofpickaxe = tonumber(levelofpickaxe) -- convertit le caractère en nombre
            --remplace l'itemstack par une nouvelle pioche
            if levelofpickaxe == 1 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl1")
            elseif levelofpickaxe == 2 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl2")
            elseif levelofpickaxe == 3 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl3")
            elseif levelofpickaxe == 4 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl4")
            elseif levelofpickaxe == 5 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl5")
            end
            --met à jour les metadata de l'itemstack
            local meta = itemstack:get_meta()
            meta:set_int("counter", counter)
            
           --minetest.chat_send_all("La pioche est maintenant de niveau 50!")
              local enchantment = "efficiency"
                local enchantment_level = 3
                local can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
                if can_enchant then
                    itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
                    minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Efficiency 3!")
                else
                    minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
                end
                enchantment = "fortune"
                enchantment_level = 1
                can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
                if can_enchant then
                    itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
                    minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Fortune 1!")
                else
                    minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
                end

            
        

           

           --minetest.chat_send_all("La pioche a été enchantée avec Efficacité 3!")
              meta:set_int("level", 50)
        end
    elseif level == 75 then
        --verifie dans les metadata d l'itemstack si il est au niveau 75
        if itemstack:get_meta():get_int("level") == 75 then

        else
            --envoire un message au joueur pour lui dire que la pioche est de niveau 75
            minetest.chat_send_player(nameofuser, "the pickaxe is now level 75!")
            --replace par une nouvelle pioche pour enlever les enchantements mais doit garder les metadata
            --recupère les metadata de l'itemstack
            local meta = itemstack:get_meta()
            --recupère le counter de l'itemstack
            local counter = meta:get_int("counter")
            --recupère le niveau de l'itemstack
            local levelofpickaxe = meta:get_int("level")
            --remplace l'itemstack par une nouvelle pioche
            --recuper le niveau de la pioche dans le nom de l'item pour savoir quel pioche donner
            local levelofpickaxe = itemstack:get_name():sub(-1) -- récupère le dernier caractère du nom de l'item
            levelofpickaxe = tonumber(levelofpickaxe) -- convertit le caractère en nombre
            --remplace l'itemstack par une nouvelle pioche
            if levelofpickaxe == 1 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl1")
            elseif levelofpickaxe == 2 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl2")
            elseif levelofpickaxe == 3 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl3")
            elseif levelofpickaxe == 4 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl4")
            elseif levelofpickaxe == 5 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl5")
            end
            --met à jour les metadata de l'itemstack
            local meta = itemstack:get_meta()
            meta:set_int("counter", counter)
            
           --minetest.chat_send_all("La pioche est maintenant de niveau 75!")
           local enchantment = "efficiency"
           local enchantment_level = 4
           
           local can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
           if can_enchant then
               itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
               minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Efficiency 4!")
           else
               minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
           end

           --on donne fortune 2
              enchantment = "fortune"
                enchantment_level = 2
                can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
                if can_enchant then
                    itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
                    minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Fortune 2!")
                else
                    minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
                end
           

           --minetest.chat_send_all("La pioche a été enchantée avec Efficacité 4!")
           meta:set_int("level", 75)
        end
    elseif level == 85
    then
        --verifie dans les metadata d l'itemstack si il est au niveau 85
        if itemstack:get_meta():get_int("level") == 85 then

        else
            --si non alors on met à jour les metadata de l'itemstack
            local meta = itemstack:get_meta()
            meta:set_int("level", 85)
            --envoire un message au joueur pour lui dire que la pioche est de niveau 85
            minetest.chat_send_player(nameofuser, "the pickaxe is now level 85!")
           --minetest.chat_send_all("La pioche est maintenant de niveau 85!")
            --replace par une nouvelle pioche pour enlever les enchantements mais doit garder les metadata
            --recupère les metadata de l'itemstack
            local meta = itemstack:get_meta()
            --recupère le counter de l'itemstack
            local counter = meta:get_int("counter")
            --recupère le niveau de l'itemstack
            local levelofpickaxe = meta:get_int("level")
            --remplace l'itemstack par une nouvelle pioche
            --recuper le niveau de la pioche dans le nom de l'item pour savoir quel pioche donner
            local levelofpickaxe = itemstack:get_name():sub(-1) -- récupère le dernier caractère du nom de l'item
            levelofpickaxe = tonumber(levelofpickaxe) -- convertit le caractère en nombre
            --remplace l'itemstack par une nouvelle pioche
            if levelofpickaxe == 1 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl1")
            elseif levelofpickaxe == 2 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl2")
            elseif levelofpickaxe == 3 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl3")
            elseif levelofpickaxe == 4 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl4")
            elseif levelofpickaxe == 5 then
                itemstack:replace("evolving_pickaxe:pick_wood_lvl5")
            end
            --met à jour les metadata de l'itemstack
            local meta = itemstack:get_meta()
            meta:set_int("counter", counter)
            
           local enchantment = "efficiency"
           local enchantment_level = 5
           
           local can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
           if can_enchant then
               itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
               minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Efficiency 5!")
           else
               minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
           end

           --on donne fortune 3
              enchantment = "fortune"
                enchantment_level = 3
                can_enchant, errorstring, extra_info = mcl_enchanting.can_enchant(itemstack, enchantment, enchantment_level)
                if can_enchant then
                    itemstack = mcl_enchanting.enchant(itemstack, enchantment, enchantment_level)
                    minetest.chat_send_player(nameofuser, "the pickaxe has been enchanted with Fortune 3!")
                else
                    minetest.chat_send_player(nameofuser, "impossible to enchant the pickaxe: " .. errorstring)
                end
           

           --minetest.chat_send_all("La pioche a été enchantée avec Efficacité 5!")
           meta:set_int("level", 85)
        end
    end




    --si le niveau de la pioche est supérieur à 100 alors on la change contre la pioche de niveau supérieur
    if level >= 100 then
        if levelofpickaxe == 1 then
            itemstack:replace("evolving_pickaxe:pick_wood_lvl2")
        elseif levelofpickaxe == 2 then
            itemstack:replace("evolving_pickaxe:pick_wood_lvl3")
        elseif levelofpickaxe == 3 then
            itemstack:replace("evolving_pickaxe:pick_wood_lvl4")
        elseif levelofpickaxe == 4 then
            itemstack:replace("evolving_pickaxe:pick_wood_lvl5")
        end
    end
    
    return level
end








minetest.register_tool("evolving_pickaxe:pick_wood_lvl1", { 
    description = "Pikaxe evolving in wood", 
    inventory_image = "evolving_pickaxe_evolving_pickaxe_lvl1.png", 
    _doc_items_longdesc = pickaxe_longdesc, 
    _doc_items_hidden = false, 
    wield_scale = wield_scale, 
    groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=15}, 
    tool_capabilities = {
        full_punch_interval = 0.83333333, 
        max_drop_level = 1, 
        damage_groups = {fleshy=2}, 
    },
    sound = { breaks = "default_tool_breaks" }, 
    _repair_material = "group:wood", 
    _mcl_toollike_wield = true, 
    _mcl_diggroups = {
        pickaxey = { speed = 2, level = 1, uses = 0 }
    },
    metadata = { counter = 0, level = 1 }, 
    on_secondary_use = function(itemstack, user, pointed_thing)
        local meta = itemstack:get_meta()
        local count = meta:get_int("counter") 
        local level = calculate_pickaxe_level(itemstack, count, 1, user:get_player_name())
        minetest.chat_send_player(user:get_player_name(), "the pickaxe is level " .. level)
        minetest.chat_send_player(user:get_player_name(), "block broken: " .. count)
        return itemstack
    end,
    on_add_enchantment = function(itemstack, enchantment)
        local meta = itemstack:get_meta()
        local enchantments = meta:get_string("enchantments")
        if enchantments == "" then
            enchantments = {}
        else
            enchantments = minetest.deserialize(enchantments)
        end
        table.insert(enchantments, enchantment)
        meta:set_string("enchantments", minetest.serialize(enchantments))
        mcl_enchanting.update_groupcaps(itemstack)
        return itemstack
    end
})

function apply_enchantment(itemstack, enchantment)
    if itemstack:get_name() == "evolving_pickaxe:pick_wood_lvl1" then
        itemstack = minetest.registered_tools["evolving_pickaxe:pick_wood_lvl1"].on_add_enchantment(itemstack, enchantment)
    end
    return itemstack
end






-- Fonction pour mettre à jour le counter de la pioche
local function update_pickaxe_counter(itemstack)
    local meta = itemstack:get_meta()
    local count = meta:get_int("counter") or 0
    count = count + 1
    meta:set_int("counter", count)
    return itemstack
end

-- Action spéciale lorsque le bloc est cassé
minetest.register_on_dignode(function(pos, oldnode, digger)
    if digger and digger:is_player() then
        local wielded_item = digger:get_wielded_item()
        if wielded_item:get_name():find("evolving_pickaxe:pick_wood_lvl") then
            -- recupère le niveau de la pioche dans le nom de l'item
            local level = wielded_item:get_name():sub(-1) -- récupère le dernier caractère du nom de l'item
            level = tonumber(level) -- convertit le caractère en nombre
            --apelle la fonction pour calculer le niveau de la pioche
            local level = calculate_pickaxe_level(wielded_item, wielded_item:get_meta():get_int("counter"), level, digger:get_player_name())
            -- Vérifie si un mod est installé (blockwatch) pour voir les données du bloc cassé
            if minetest.get_modpath("blockwatch") then
                -- Appelle la fonction blockwatch.events_stats() pour afficher
                local stats = blockwatch.events_stats()
               --minetest.chat_send_player(digger:get_player_name(), tostring(stats))
                
                -- Appelle la fonction blockwatch.get_events(pos) pour afficher les données du bloc cassé
                local events = blockwatch.get_events(pos)
                -- Vérifie si des événements sont enregistrés pour cette position
                if events and #events > 0 then
                   --minetest.chat_send_player(digger:get_player_name(), "Événements enregistrés pour la position " .. minetest.pos_to_string(pos) .. ":")
                    for _, event in ipairs(events) do
                        local event_msg = string.format("[%s] %s %s - Node: %s",
                                        event.timestamp, event.event_type, event.entity or "Unknown", event.node_name)
                       --minetest.chat_send_player(digger:get_player_name(), event_msg)
                    end
                else
                   --minetest.chat_send_player(digger:get_player_name(), "Aucun événement enregistré pour la position " .. minetest.pos_to_string(pos))
                    if wielded_item:get_name():find("evolving_pickaxe:pick_wood_lvl") then
                        wielded_item = update_pickaxe_counter(wielded_item)
                        digger:set_wielded_item(wielded_item)
                        local meta = wielded_item:get_meta()
                        local count = meta:get_int("counter")
                       --minetest.chat_send_player(digger:get_player_name(), "Vous avez cassé un bloc avec la Pioche Évolutive en Bois! counter: " .. count)
                    end
                end
            else
               --minetest.chat_send_player(digger:get_player_name(), "Le mod blockwatch n'est pas installé")
                if wielded_item:get_name():find("evolving_pickaxe:pick_wood_lvl") then
                    wielded_item = update_pickaxe_counter(wielded_item)
                    digger:set_wielded_item(wielded_item)
                    local meta = wielded_item:get_meta()
                    local count = meta:get_int("counter")
                   --minetest.chat_send_player(digger:get_player_name(), "Vous avez cassé un bloc avec la Pioche Évolutive en Bois! counter: " .. count)
                end
            end
        end
    end
end)






minetest.register_tool("evolving_pickaxe:pick_wood_lvl2", { -- cette pioche est en pierre (lvl 2)
    description = "Pikaxe evolving in stone",
    inventory_image = "evolving_pickaxe_evolving_pickaxe_lvl2.png",
	_doc_items_longdesc = pickaxe_longdesc,
	
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=3, enchantability=15 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=3,
		damage_groups = {fleshy=3},
	},
	sound = { breaks = "default_tool_breaks" },
	
	_repair_material = "group:cobble",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 3, uses = 0 }
    }, -- ajout de l'accolade fermante ici
    metadata = "0", -- initialiser le counter à 0
    --fonction quand on clique droit avec la pioche en main pour afficher le counter
    on_secondary_use = function(itemstack, user, pointed_thing)
        local meta = itemstack:get_meta()
        local count = meta:get_int("counter")
        --apeller la fonction pour calculer le niveau de la pioche
        local level = calculate_pickaxe_level(itemstack, count, 2, user:get_player_name())
       minetest.chat_send_player(user:get_player_name(), "the pickaxe is level " .. level)
       minetest.chat_send_player(user:get_player_name(), "block broken: " .. count)
        return itemstack
    end
})


minetest.register_tool("evolving_pickaxe:pick_wood_lvl3", { -- cette pioche est en fer (lvl 3)
    description = "Pickaxe evolving in iron",
    inventory_image = "evolving_pickaxe_evolving_pickaxe_lvl3.png",
	_doc_items_longdesc = pickaxe_longdesc,
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=4, enchantability=14 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=4,
		damage_groups = {fleshy=4},
	},
	sound = { breaks = "default_tool_breaks" },
	
	_repair_material = "mcl_core:iron_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 6, level = 4, uses = 0 }
	},
    metadata = "0", -- initialiser le counter à 0
    --fonction quand on clique droit avec la pioche en main pour afficher le counter
    on_secondary_use = function(itemstack, user, pointed_thing)
        local meta = itemstack:get_meta()
        local count = meta:get_int("counter")
        --apeller la fonction pour calculer le niveau de la pioche
        local level = calculate_pickaxe_level(itemstack, count, 3, user:get_player_name())
       minetest.chat_send_player(user:get_player_name(), "the pickaxe is level " .. level)
       minetest.chat_send_player(user:get_player_name(), "block broken: " .. count)
        return itemstack
    end
})

minetest.register_tool("evolving_pickaxe:pick_wood_lvl4", { -- cette pioche est en diamant (lvl 4)
    description = "Pickaxe evolving in diamond",
    inventory_image = "evolving_pickaxe_evolving_pickaxe_lvl4.png",
	_doc_items_longdesc = pickaxe_longdesc,
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=5, enchantability=10 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=5,
		damage_groups = {fleshy=5},
	},
	sound = { breaks = "default_tool_breaks" },
	
	_repair_material = "mcl_core:diamond",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 8, level = 5, uses = 0 }
	},
    metadata = "0", -- initialiser le counter à 0
    --fonction quand on clique droit avec la pioche en main pour afficher le counter
    on_secondary_use = function(itemstack, user, pointed_thing)
        local meta = itemstack:get_meta()
        local count = meta:get_int("counter")
        --apeller la fonction pour calculer le niveau de la pioche
        local level = calculate_pickaxe_level(itemstack, count, 4, user:get_player_name())
       minetest.chat_send_player(user:get_player_name(), "the pickaxe is level " .. level)
       minetest.chat_send_player(user:get_player_name(), "block broken: " .. count)
        return itemstack
    end
})

minetest.register_tool("evolving_pickaxe:pick_wood_lvl5", { -- cette pioche est en netherite (lvl 5)
    description = "Pickaxe evolving in netherite",
    inventory_image = "evolving_pickaxe_evolving_pickaxe_lvl5.png",
	_doc_items_longdesc = pickaxe_longdesc,
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=6, enchantability=10, fire_immune=1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=5,
		damage_groups = {fleshy=6},
	},
	sound = { breaks = "default_tool_breaks" },
	
	_repair_material = "mcl_nether:netherite_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 9.5, level = 6, uses = 0 }
	},
    metadata = "0", -- initialiser le counter à 0
    --fonction quand on clique droit avec la pioche en main pour afficher le counter
    on_secondary_use = function(itemstack, user, pointed_thing)
        local meta = itemstack:get_meta()
        local count = meta:get_int("counter")
        --apeller la fonction pour calculer le niveau de la pioche
        local level = calculate_pickaxe_level(itemstack, count, 5, user:get_player_name())
       minetest.chat_send_player(user:get_player_name(), "the pickaxe is level " .. level)
       minetest.chat_send_player(user:get_player_name(), "block broken: " .. count)
        return itemstack
    end
})


-- Définir le bloc
minetest.register_node("evolving_pickaxe:modifier_block", {
    description = "bloc of pickaxe modification (admin only)",
    tiles = {"evolving_pickaxe_heart_of_the_pickaxe.png", "evolving_pickaxe_heart_of_the_pickaxe.png", "evolving_pickaxe_heart_of_the_pickaxe.png"},
    groups = {cracky = 3, stone = 1},
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec", "size[8,9]" ..
            "list[current_name;main;3.5,1.5;1,1;]" ..
            "field[2.5,3.5;3,1;counter;Counter:;" .. "" .. "]" ..
            "button[3,4.5;2,1;modify;edit the counter]" ..
            "list[current_player;main;0,5;8,4;]")
        meta:set_string("infotext", "Bloc de Modification de Pioche")
        local inv = meta:get_inventory()
        inv:set_size("main", 1)
    end,
    on_receive_fields = function(pos, formname, fields, sender)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        local stack = inv:get_stack("main", 1)

        if fields.modify and not stack:is_empty() then
            local item_meta = stack:get_meta()
            local new_counter = tonumber(fields.counter)
            if new_counter then
                item_meta:set_int("counter", new_counter)
                stack:set_metadata(item_meta:to_table().metadata or "")
                inv:set_stack("main", 1, stack)
               --minetest.chat_send_player(sender:get_player_name(), "La métadonnée de l'objet a été modifiée.")
            else
               --minetest.chat_send_player(sender:get_player_name(), "Valeur de counter invalide.")
            end
        elseif not stack:is_empty() then
            local item_meta = stack:get_meta()
            local current_counter = item_meta:get_int("counter")
            meta:set_string("formspec", "size[8,9]" ..
                "list[current_name;main;3.5,1.5;1,1;]" ..
                "field[2.5,3.5;3,1;counter;counter:;" .. current_counter .. "]" ..
                "button[3,4.5;2,1;modify;edit the counter]" ..
                "list[current_player;main;0,5;8,4;]")
        else
            meta:set_string("formspec", "size[8,9]" ..
                "list[current_name;main;3.5,1.5;1,1;]" ..
                "field[2.5,3.5;3,1;counter;counter:;" .. "" .. "]" ..
                "button[3,4.5;2,1;modify;edit the counter]" ..
                "list[current_player;main;0,5;8,4;]")
        end
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        local meta = minetest.get_meta(pos)
        local item_meta = stack:get_meta()
        local current_counter = item_meta:get_int("counter")
        meta:set_string("formspec", "size[8,9]" ..
            "list[current_name;main;3.5,1.5;1,1;]" ..
            "field[2.5,3.5;3,1;counter;counter:;" .. current_counter .. "]" ..
            "button[3,4.5;2,1;modify;edit the counter]" ..
            "list[current_player;main;0,5;8,4;]")
        meta:set_string("infotext", "Bloc of pickaxe modification")
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec", "size[8,9]" ..
            "list[current_name;main;3.5,1.5;1,1;]" ..
            "field[2.5,3.5;3,1;counter;counter:;" .. "" .. "]" ..
            "button[3,4.5;2,1;modify;edit the counter]" ..
            "list[current_player;main;0,5;8,4;]")
        meta:set_string("infotext", "Bloc of pickaxe modification")
    end
})
-- block de modification de la pioche pour modifier le level de la pioche dans le metadata de l'itemstack
minetest.register_node("evolving_pickaxe:modifier_block2", {
    description = "bloc of pickaxe modification (admin only)",
    tiles = {"evolving_pickaxe_heart_of_the_pickaxe.png", "evolving_pickaxe_heart_of_the_pickaxe.png", "evolving_pickaxe_heart_of_the_pickaxe.png"},
    groups = {cracky = 3, stone = 1},
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec", "size[8,9]" ..
            "list[current_name;main;3.5,1.5;1,1;]" ..
            "field[2.5,3.5;3,1;level;Level:;" .. "" .. "]" ..
            "button[3,4.5;2,1;modify;edit the level]" ..
            "list[current_player;main;0,5;8,4;]")
        meta:set_string("infotext", "Bloc de Modification de Pioche")
        local inv = meta:get_inventory()
        inv:set_size("main", 1)
    end,
    on_receive_fields = function(pos, formname, fields, sender)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        local stack = inv:get_stack("main", 1)

        if fields.modify and not stack:is_empty() then
            local item_meta = stack:get_meta()
            local new_level = tonumber(fields.level)
            if new_level then
                item_meta:set_int("level", new_level)
                stack:set_metadata(item_meta:to_table().metadata or "")
                inv:set_stack("main", 1, stack)
               --minetest.chat_send_player(sender:get_player_name(), "La métadonnée de l'objet a été modifiée.")
            else
               --minetest.chat_send_player(sender:get_player_name(), "Valeur de level invalide.")
            end
        elseif not stack:is_empty() then
            local item_meta = stack:get_meta()
            local current_level = item_meta:get_int("level")
            meta:set_string("formspec", "size[8,9]" ..
                "list[current_name;main;3.5,1.5;1,1;]" ..
                "field[2.5,3.5;3,1;level;Level:;" .. current_level .. "]" ..
                "button[3,4.5;2,1;modify;edit the level]" ..
                "edit the level]" ..
                "list[current_player;main;0,5;8,4;]")
        else
            meta:set_string("formspec", "size[8,9]" ..
                "list[current_name;main;3.5,1.5;1,1;]" ..
                "field[2.5,3.5;3,1;level;Level:;" .. "" .. "]" ..
                "button[3,4.5;2,1;modify;edit the level]" ..
                "list[current_player;main;0,5;8,4;]")
        end
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        local meta = minetest.get_meta(pos)
        local item_meta = stack:get_meta()
        local current_level = item_meta:get_int("level")
        meta:set_string("formspec", "size[8,9]" ..
            "list[current_name;main;3.5,1.5;1,1;]" ..
            "field[2.5,3.5;3,1;level;Level:;" .. current_level .. "]" ..
            "button[3,4.5;2,1;modify;edit the level]" ..
            "list[current_player;main;0,5;8,4;]")
        meta:set_string("infotext", "Bloc of pickaxe modification")
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec", "size[8,9]" ..
            "list[current_name;main;3.5,1.5;1,1;]" ..
            "field[2.5,3.5;3,1;level;Level:;" .. "" .. "]" ..
            "button[3,4.5;2,1;modify;edit the level]" ..
            "list[current_player;main;0,5;8,4;]")
        meta:set_string("infotext", "Bloc of pickaxe modification")
    end
})




--declare l'item Heart of the Pickaxe
minetest.register_craftitem("evolving_pickaxe:heart_of_the_pickaxe", {
    description = "the heart of the pickaxe",
    inventory_image = "evolving_pickaxe_heart_of_the_pickaxe.png",
})

--declare le craft pour l'item Heart of the Pickaxe
minetest.register_craft({
    output = "evolving_pickaxe:heart_of_the_pickaxe",
    recipe = {
        {"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},
        {"mcl_core:diamond", "mcl_nether:netherite_ingot", "mcl_core:diamond"},
        {"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},
    }
})

--craft pour la pioche en bois lvl 1
--2 diamon sur les côtés et 1 heart of the pickaxe au milieu et des sticks en bas
minetest.register_craft({
    output = "evolving_pickaxe:pick_wood_lvl1",
    recipe = {
        {"mcl_core:diamond", "evolving_pickaxe:heart_of_the_pickaxe", "mcl_core:diamond"},
        {"", "evolving_pickaxe:stick", ""},
        {"", "evolving_pickaxe:stick", ""},
    }
})

--craft pour le stick avec des planches de bois et des lingots de fer
minetest.register_craft({
    output = "evolving_pickaxe:stick 2",
    recipe = {
        {"group:wood", "mcl_core:iron_ingot", "group:wood"},
        {"group:wood", "mcl_core:iron_ingot", "group:wood"},
        {"", "", ""},
    }
})

--declare item stick pour le craft de la pioche en bois lvl 1
minetest.register_craftitem("evolving_pickaxe:stick", {
    description = "stick",
    inventory_image = "evolving_pickaxe_stick.png",
})