# GamerIPVault API

The **GamerIPVault** mod provides an API to interact with player IP data in Minetest. Below is a detailed description of the available functions and their usage.

## Table of Contents

- [Functions](#functions)
  - [read_json_file(path)](#read_json_filepath)
  - [write_json_file(path, data)](#write_json_filepath-data)
  - [table_contains(tbl, value)](#table_containstbl-value)
  - [get_player_ip_hash(player_name)](#get_player_ip_hashplayer_name)
  - [get_players_with_same_ip(player_name)](#get_players_with_same_ipplayer_name)
  - [save_ip_hashed(player_name, player_ip_hash)](#save_ip_hashedplayer_name-player_ip_hash)
  - [create_message_for_chat(name, param, data, key, is_players)](#create_message_for_chatname-param-data-key-is_players)
  - [get_ip(player_name)](#get_ipplayer_name)
  - [get_players_with_same_ip_hash(ip_hash)](#get_players_with_same_ip_haship_hash)
  - [find_players_with_same_ips(player_name)](#find_players_with_same_ipsplayer_name)

## Functions

### `gameripvault.read_json_file(path)`

Reads the content of a JSON file.

- **Parameters:**
  - `path` (string): The file path to read the JSON data from.
  
- **Returns:**
  - `table`: The parsed JSON data as a Lua table.
  - `error` (string): An error message if the file could not be read.

### `gameripvault.write_json_file(path, data)`

Writes data to a JSON file.

- **Parameters:**
  - `path` (string): The file path to write the JSON data to.
  - `data` (table): The Lua table to be written as JSON.
  
- **Returns:**
  - `boolean`: `true` if the write operation was successful, `false` otherwise.
  - `error` (string): An error message if the file could not be written.

### `gameripvault.table_contains(tbl, value)`

Checks if a table contains a specific value.

- **Parameters:**
  - `tbl` (table): The table to search.
  - `value` (any): The value to search for in the table.
  
- **Returns:**
  - `boolean`: `true` if the table contains the value, `false` otherwise.

### `gameripvault.get_player_ip_hash(player_name)`

Retrieves the hashed IP address of a player.

- **Parameters:**
  - `player_name` (string): The name of the player.
  
- **Returns:**
  - `string`: The hashed IP address of the player.
  - `error` (string): An error message if the IP could not be retrieved.

### `gameripvault.get_players_with_same_ip(player_name)`

Finds players who have used the same IP address as the specified player.

- **Parameters:**
  - `player_name` (string): The name of the player to check against.
  
- **Returns:**
  - `table`: A list of players who share the same IP address.
  - `error` (string): An error message if the operation fails.

### `gameripvault.save_ip_hashed(player_name, player_ip_hash)`

Saves the hashed IP address of a player to the JSON file.

- **Parameters:**
  - `player_name` (string): The name of the player.
  - `player_ip_hash` (string): The hashed IP address to save.
  
- **Returns:**
  - `boolean`: `true` if the save operation was successful, `false` otherwise.
  - `error` (string): An error message if the data could not be saved.

### `gameripvault.create_message_for_chat(name, param, data, key, is_players)`

Creates a message for chat based on the given parameters and displays it to the player.

- **Parameters:**
  - `name` (string): The name of the player to receive the message.
  - `param` (string): The parameter used to generate the message.
  - `data` (table): The data to search through.
  - `key` (string): The key to search for.
  - `is_players` (boolean): If `true`, searches for players; if `false`, searches for IP addresses.
  
- **Returns:**
  - None. Displays the message in chat and shows a formspec.

### `gameripvault.get_ip(player_name)`

Retrieves the list of IP addresses associated with a specific player.

- **Parameters:**
  - `player_name` (string): The name of the player.
  
- **Returns:**
  - `table`: A list of hashed IP addresses associated with the player.
  - `error` (string): An error message if the operation fails.

### `gameripvault.get_players_with_same_ip_hash(ip_hash)`

Finds players who have used the same hashed IP address.

- **Parameters:**
  - `ip_hash` (string): The hashed IP address to search for.
  
- **Returns:**
  - `table`: A list of players who have used the same hashed IP address.
  - `error` (string): An error message if the operation fails.

### `gameripvault.find_players_with_same_ips(player_name)`

Finds players who have used the same IP addresses as the specified player.

- **Parameters:**
  - `player_name` (string): The name of the player to check against.
  
- **Returns:**
  - `table`: A list of players who have used the same IP addresses.
  - `error` (string): An error message if the operation fails.

## Notes

- The mod uses hashed IP addresses for privacy reasons.
- Ensure compliance with local data protection laws when using or modifying this mod.

## Contact

For further questions or support, please reach out to the mod author via the contact details provided in the Codeberg repository or Minetest forums.

---

Thank you for using **GamerIPVault**! We hope this API documentation helps you integrate and utilize the mod effectively.
