# GamerIPVault

**GamerIPVault** is a Minetest mod designed to track players' IP addresses and check connections between different players based on their IP addresses. It is intended to help server administrators manage abuse and monitor suspicious behavior by associating IP addresses with players.

## Features

- Records hashed IP addresses of players upon their connection.
- Searches for players who have used the same IP address.
- Searches for IP addresses associated with a specific player.
- Displays results in Minetest chat and formspecs.

## Installation

1. Download the **GamerIPVault** mod from GitHub or another trusted source.
2. Extract the downloaded archive (if necessary).
3. Copy the `gameripvault` folder into the `mods` directory of your Minetest server.
4. Ensure the mod is enabled in the `minetest.conf` file or via the server administration interface.

## Configuration

No specific configuration is required to use **GamerIPVault**. The mod works immediately after installation.

## Commands

Here are the available commands with this mod:

### `/getip <username>`

Displays the IP addresses where the specified player has connected.

- **Example:** `/getip player1`

### `/getplayers <hash>`

Displays the players who have used the same hashed IP address as the one provided.

- **Example:** `/getplayers abcdef1234567890`

### `/findsameips <username>`

Displays players who have used the same IPs as the specified player.

- **Example:** `/findsameips player1`

## Permissions

To use the commands provided by the mod, a player must have the `gameripvault` privilege. Server administrators should ensure that the appropriate permissions are assigned:

- **gameripvault**: Allows the use of GamerIPVault commands.

Permissions can be assigned via the `minetest.conf` file or through Minetest's privilege management commands.

## Notes

- This mod stores players' IP addresses in a hashed format for privacy reasons.
- Make sure to comply with local laws and regulations regarding the management of personal data and player privacy.

## Contributions

Contributions are welcome! If you would like to improve the mod or add new features, please submit a pull request on the GitHub repository.

## License

This mod is licensed under the [Creative Commons Attribution-ShareAlike 4.0 International License (CC BY-SA 4.0)](https://creativecommons.org/licenses/by-sa/4.0/). You are free to use, modify, and distribute it under the terms of this license, provided you attribute the original author and share derivative works under the same license.

## Contact

For any questions or support, please contact the mod author at the email address provided in the Codeberg repository or on Minetest forums.

---

Thank you for using **GamerIPVault**! We hope this mod helps you maintain a healthy and secure gaming environment for your players.
