minetest.register_node("tripwire:filsel", {
    description = "Fils",
    tiles = {"tripwire_filsel.png"},
    drawtype = "nodebox",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    pointable = false,
    diggable = true, -- Les fils peuvent être détruits par le joueur
    buildable_to = true,
    node_box = {
        type = "fixed",
        fixed = {
            {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
        },
    },
})

-- Enregistrement du bloc "tripwire" -- c'est un block sandard
minetest.register_node("tripwire:tripwire", {
    description = "Tripwire",
    tiles = {"tripwire_tripwire.png"},
    --cree un timer 
    on_construct = function(pos)
        minetest.get_node_timer(pos):start(1)
    end,
    --quand le timer est fini il envoie un message dans le chat
    on_timer = function(pos, elapsed)
        minetest.chat_send_all("Timer fini")
        --relance le timer
        --verifie si un autre fil est a coté si oui il envoie un message dans le chat en utilisant la fonction is_filsel
        for _,dir in ipairs({"x", "y", "z"}) do --boucle pour verifier les 3 directions
            for _,sign in ipairs({1, -1}) do --boucle pour verifier les 2 signes
                local p = vector.new(pos)
                p[dir] = p[dir] + sign
                if minetest.get_node(p).name == "tripwire:filsel" then
                    local dir = minetest.facedir_to_dir(minetest.dir_to_facedir(vector.subtract(p, pos))) --recupre la direction qu'il y a entre le tripwire et le fil
                    minetest.chat_send_all("Direction: " .. minetest.write_json(dir)) --envoie un message dans le chat
                    --recupere la position du block original
                    local p = vector.new(pos)
                    if is_filsel(p, dir) then
                        minetest.chat_send_all("Tripwire connecté")
                        --recupere la position du block original
                        local p = vector.new(pos)
                        --recupere la potion du block connecté
                        --ca va chercher le block Tripwire le plus proche de p dans la direction dir
                        p = vector.add(p, dir)
                        while minetest.get_node(p).name == "tripwire:filsel" do
                            p = vector.add(p, dir)
                        end
                        -- envoir un message dans le chat
                        local po = vector.new(pos)
                        minetest.chat_send_all(minetest.write_json(po) .. "Connected to: " .. minetest.write_json(p)) 
                        --remplace le tripwire par un tripwire allumé
                        tripwire_on(pos, p)
                    else
                        minetest.chat_send_all("Tripwire non connecté")
                    end
                end
            end
        end
        minetest.get_node_timer(pos):start(1)
    end,
})


--fonction pour verifier si un Tripwire est conetecté a un autre via un ou plusieurs fils
function is_filsel(pos, dir)
    --verifie si pos est un tripwire
    if minetest.get_node(pos).name == "tripwire:tripwire" then 
        --commence une boucle pour verifier si le block suivant est un fil ou un tripwire
        --temps que le block suivant est un fil 
        pos = vector.add(pos, dir)
        while minetest.get_node(pos).name == "tripwire:filsel" do --tant que le block suivant est un fil
            --ajoute la direction a pos
            pos = vector.add(pos, dir) --ajoute la direction a pos
        end
        --verifie si le block suivant est un tripwire
        if minetest.get_node(pos).name == "tripwire:tripwire" then
            return true
        end
    else 
        --envoie un message dans le chat si le block n'est pas un tripwire
        minetest.chat_send_all("Pas un tripwire")
    end
    return false
end


--fonction pour ranplacer un tripwire par un tripwire allumé avec la position du block connecté (il le fait pour les 2 blocks)
function tripwire_on(pos ,pos2)
    minetest.set_node(pos, {name = "tripwire:tripwire_on"})
    minetest.set_node(pos2, {name = "tripwire:tripwire_on"})
    local meta = minetest.get_meta(pos)
    meta:set_string("connected", minetest.write_json(pos2))
    local meta = minetest.get_meta(pos2)
    meta:set_string("connected", minetest.write_json(pos))
end

minetest.register_node("tripwire:tripwire_on", {
    description = "Tripwire allumé",
    tiles = {"tripwire_tripwire_on.png"},
    groups = {not_in_creative_inventory = 1},
    drop = "tripwire:tripwire",
    --doit stoquer le block au quel il est connecté et utilise la position 0 0 0 par default
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_string("connected", minetest.write_json({x = 0, y = 0, z = 0}))
        minetest.get_node_timer(pos):start(1)
    end,
    --cree le timer et envoie un message dans le chat qui dit quelle est la cordonner du block connecté et le block original
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        --donne toute les informations du block
        local meta = minetest.get_meta(pos)
        local connected = minetest.parse_json(meta:get_string("connected"))
        minetest.chat_send_all("Connected to: " .. minetest.write_json(connected))
        minetest.chat_send_all("Original: " .. minetest.write_json(pos))
    end,
    on_timer = function(pos, elapsed)
        mesecon.receptor_off(pos, mesecon.rules.alldirs)
        minetest.chat_send_all("Timer fini")
        local meta = minetest.get_meta(pos)
        local connected = minetest.parse_json(meta:get_string("connected"))
        minetest.chat_send_all("Connected to: " .. minetest.write_json(connected))
        --verifie si le block connecté est un tripwire
        if minetest.get_node(connected).name == "tripwire:tripwire_on" then
            minetest.chat_send_all("Connected to a tripwire")
        else
            minetest.chat_send_all("Connected to a non-tripwire")
            --remplace le block par un tripwire
            minetest.set_node(pos, {name = "tripwire:tripwire"})
        end

        --compte le nombre de block entre le block original et le block connecté
        local count = 0
        local p = vector.new(pos) --recupere la position du block original
        while not vector.equals(p, connected) do --tant que p n'est pas égale a connected
            p = vector.add(p, vector.direction(pos, connected)) --ajoute la direction a p
            count = count + 1 --ajoute 1 a count
        end
        minetest.chat_send_all("Count: " .. count) --envoie un message dans le chat avec le nombre de block entre le block original et le block connecté


        x = 0
        y = 0
        z = 0

        --verrifie si le y des 2 blocks est le meme
        if pos.y == connected.y then
            minetest.chat_send_all("Y is the same")
            Y = connected.y
        else
            minetest.chat_send_all("Y is not the same")
        end
        --verifie si le x des 2 blocks est le meme
        if pos.x == connected.x then
            minetest.chat_send_all("X is the same")
            x = connected.x
        else
            minetest.chat_send_all("X is not the same")
        end
        --verifie si le z des 2 blocks est le meme
        if pos.z == connected.z then
            minetest.chat_send_all("Z is the same")
            z = connected.z
        else
            minetest.chat_send_all("Z is not the same")
        end


        --localise les entités dans un rayon de la distance entre le block original et le block connecté
        local objs = minetest.get_objects_inside_radius(pos, count)
        for _,obj in ipairs(objs) do
            --envoi un message dans le chat si une entité est detecté
            --recupere la position de l'entité
            minetest.chat_send_all("Entity detected at: " .. minetest.write_json(obj:get_pos()))
            minetest.chat_send_all("Entity doit se touver entre le block original " .. minetest.write_json(pos) .. " et le block connecté " .. minetest.write_json(connected))
            --verifie si l'entity est entre le block original et le block connecté
            -- recupere la position de l'entité
            xe = obj:get_pos().x
            ye = obj:get_pos().y
            ze = obj:get_pos().z
            if x == 0 then --si x est égale a 0 l'entitié doit se trouver entre le x du block original et le x du block connecté
                --pour recupere le x des 2 blocks c'est la variable pos et connected
                if pos.x > xe and xe > connected.x then --si l'entité est entre les 2 blocks
                    minetest.chat_send_all("Entity is between the blocks x")
                    --allume la redstone
                    mesecon.receptor_on(pos, mesecon.rules.alldirs)
                end
            end
            if y == 0 then --si y est égale a 0 l'entitié doit se trouver entre le y du block original et le y du block connecté
                --pour recupere le y des 2 blocks c'est la variable pos et connected
                if pos.y < ye and ye < connected.y then --si l'entité est entre les 2 blocks
                    minetest.chat_send_all("Entity is between the blocks y")
                    mesecon.receptor_on(pos, mesecon.rules.alldirs)
                end
            end
            if z == 0 then --si z est égale a 0 l'entitié doit se trouver entre le z du block original et le z du block connecté
                --pour recupere le z des 2 blocks c'est la variable pos et connected
                if pos.z < ze and ze < connected.z or pos.z > ze and ze > connected.z  then --si l'entité est entre les 2 blocks
                    minetest.chat_send_all("Entity is between the blocks z")
                    if pos.x - 0.5 < xe and xe < connected.x + 0.5 then
                        if pos.y - 1.5 < ye and ye < connected.y + 0.5 then
                            mesecon.receptor_on(pos, mesecon.rules.alldirs)
                        end
                    end

                end
            end
                

        end





        minetest.get_node_timer(pos):start(1)
    end,
})
