orion.craft = {}
orion.craft.type = { fuel = {}, hand = {}}

orion.craft.register = function(craft_type, inputs, outputs)
	-- example
	-- inputs = { "orionworld:stone": 3, "orioncraft:stick": 1 }
	-- outpus = { "orionworld:fire": 1, "orionworld:stone": 3}

	if #inputs > 32 then return false, "Maximum 32 inputs for recipe" end

	if not orion.craft.type[craft_type] then orion.craft.type[craft_type] = {} end
	-- Make sure there are no duplicates... later

	table.insert(orion.craft.type[craft_type], { inputs = inputs, outputs = outputs})
	return true
end


orion.craft.register_hand_craft = function(input, output, inputcount, outputCount)
	local inputTable = {}
	inputTable[input] = inputcount or 1
	local outputTable = {}
	outputTable[output] = outputCount or 1
	orion.craft.register("hand", inputTable, outputTable)
end


orion.craft.register_fuel = function(input, fuel_value, fuel_time)
	table.insert(orion.craft.type.fuel, { input = input, fuel = fuel_value, time = fuel_time })
end


local getItemInListCount = function(inventoryList, itemNameSearch)
	local count = 0
	for index, item in pairs(inventoryList) do
		local itemNameInventory = item:get_name()
		if itemNameSearch == itemNameInventory then
			count = count + item:get_count()
		end
	end
	return count
end


orion.get_possible_crafts = function(craft_type, inventoryList)
	local craftTable = orion.craft.type[craft_type]
	-- craftTable = {{ inputs = inputs, outputs = outputs}, { inputs = inputs, outputs = outputs}}
	if not craftTable then return {} end
	local resultsTable = {}
	-- search through the table I guess
	for _, entry in pairs(craftTable) do
		-- entry = { inputs = inputs, output = output}
		local validCount = nil
		for craftName, craftItemStack in pairs(entry["inputs"]) do
			local count = math.floor(getItemInListCount(inventoryList, craftName) / craftItemStack)
 			if validCount == nil then validCount = count else
				validCount = math.min(validCount, count)
			end
		end
		-- 4 sticks 3 steine
		-- 12 sticks und 20 steins
		-- 12 sticks / 4 sticks = 3 resultate
		-- 20 steine / 3 steine = 6,irgendwass
		-- min(beiden)

		-- output = { "mynode:blah" = 1 }
		if validCount >= 1 then
			local newItemStack
			for stackName, stackCount in pairs(entry["outputs"]) do
				 newItemStack = ItemStack(stackName .. " " .. validCount * stackCount)
			end

			table.insert(resultsTable, newItemStack)
			print(dump2(resultsTable))
		end
	end
	return resultsTable
end



orion.register_craftitem = function(name, description)
	minetest.register_craftitem(NAME .. ":" .. name, {
		description = description,
		inventory_image = NAME .. "_" .. name .. ".png"
	})
end
