NAME = minetest:get_current_modname()
WORLD = "orionworld"

local function register_craftitem(name, description)
	minetest.register_craftitem(NAME .. ":" .. name, {
		description = description,
		inventory_image = NAME .. "_" .. name .. ".png"
	})
end
local box = {
	type = "fixed",
	fixed = {
		{-0.18, -0.5, -0.1, .2, -0.45, 0.16},
	},
}

minetest.register_node(NAME .. ":rock", {
	description = "Rock",
	tiles = { NAME .. "_rock.png" },
	groups = {  },
	drawtype = "mesh",
	paramtype = "light",
	sunlight_propagates = true,
	inventory_image = NAME .. "_" .. "rock.png",
	mesh = "rock.obj",
	collision_box = box,
	selection_box = box,
	on_punch = function(pos, punchee, puncher)
        	local inv = puncher:get_inventory()
        	local item = ItemStack(NAME .. ":rock")
        	if inv:room_for_item("main",item) then
                        inv:add_item("main",item)
        	end
		minetest.remove_node(pos)
	end
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:dirt",
	decoration = NAME .. ":rock",
	name = NAME .. ":rock",
	fill_ratio = 0.0005,
	height = 1
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:grass",
	decoration = NAME .. ":rock",
	name = NAME .. ":rock",
	fill_ratio = 0.0002,
	height = 1
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:dry_grass",
	decoration = NAME .. ":rock",
	name = NAME .. ":rock",
	fill_ratio = 0.0002,
	height = 1
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:stone",
	decoration = NAME .. ":rock",
	name = NAME .. ":rock",
	fill_ratio = 0.0002,
	height = 1
})

minetest.register_entity(NAME .. ":rock", {
	initial_properties = {
		visual = "mesh",
		mesh = "rock.obj",
		visual_size = { x = 10, y = 10, z = 10 },
		collisionbox = { .18, -.5, .16, -.2, -.45, -.1 }
  },
	physical = true,
	pointable = true,
	scale = 10,
	textures = { NAME .. "_rock.png" },
	automatic_rotate = 0,
	on_punch = function(punchee, puncher) 
		local inv = puncher:get_inventory()
		local item = ItemStack(punchee.name)
		if inv:room_for_item("main",item) then
			inv:add_item("main",item)
			punchee.object:remove()
		end
	end
})
