NAME = minetest.get_current_modname()
WORLD = "orionworld"

minetest.register_node(NAME .. ":sapling", {
	description = "Tree sapling",
	groups = { flora = 2 },
	inventory_image = NAME .. "_sapling.png",
	node_dig_prediction = "air",
	tiles = { NAME .. "_sapling_X.png"},
	drawtype = "plantlike",
	walkable = false,
	paramtype = "light",
	buildable_to = true
})


minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:dirt",
	decoration = NAME .. ":sapling",
	name = NAME .. ":sapling",
	height = 1
})


minetest.register_craft({
    type = "fuel",
    recipe = NAME .. ":sapling",
    burntime = 7,
})

minetest.register_abm({
	label = "Sapling growth",
	nodenames = {NAME .. ":sapling"},
	neighbors = {WORLD .. ":grass"},
	chance = 72,
	time = 5.0,
	catch_up = true,
	action = function(pos, node)
		orion.make_tree(pos.x, pos.y -1, pos.z)
	end
})

minetest.register_abm({
	label = "Sapling dispenserrr",
	nodenames = {NAME .. ":leaf"},
	neighbors = {NAME .. ":trunk"},
	chance = 72,
	time = 10.0,
	catch_up = true,
	action = function(pos, node)
		--create ent and throw owo
	end
})
