NAME = minetest:get_current_modname()

minetest.register_alias("mapgen_stone", NAME .. ":stone")
minetest.register_alias("mapgen_dirt", NAME .. ":dirt")




local function register_plain_node(name, description, groups)
	orion.register_slab_node(NAME .. ":" .. name, {
		description = description,
		tiles = { NAME .. "_" .. name .. ".png" },
		groups = groups,
		sounds = { footstep = {name = NAME .. "_" .. name } }
	})
	orion.worldgen_register_decoration_slab(name)
end


orion.register_slab_node(NAME .. ":ice", {
	description = "Ice",
	tiles = { NAME .. "_ice.png" },
	groups = { solids = 2 },
	paramtype = "glass",
	sunlight_propagates = true,
	drawtype = "glasslike",
	inventory_image = NAME .. "_ice_icon.png"
})
orion.worldgen_register_decoration_slab(NAME .. ":ice")


orion.register_slab_node(NAME .. ":glass", {
	description = "Glass",
	tiles = { NAME .. "_glass.png" },
	groups =  { solids = 3 },
	paramtype = "glass",
	sunlight_propagates = true,
	drawtype = "glasslike",
	inventory_image = NAME .. "_glass_icon.png"
})


minetest.register_craft({
	output = NAME .. ":glass",
	type = "cooking",
	cooktime = 4,
	recipe = NAME .. ":sand"
})

register_plain_node("stone", "Stony Stone", { solids = 3 })

register_plain_node("dirt", "Dirt", { semisolids = 2})
register_plain_node("dry_grass", "dry Grass", { semisolids = 3 })
register_plain_node("grass", "Grass", { semisolids = 3 })
register_plain_node("sand", "Sand", { semisolids =1 })
