local NAME = minetest.get_current_modname()
local MAX_ENERGY = 40

local setEnergyLevelNode = function(pos)
	local meta = minetest.get_meta(pos)
	energy = meta:get_int("energy")
	local light_level = sparktech.getoption(pos, "light_level")
	local enabled = sparktech.getoption(pos, "enabled")

	local maxLevel = math.floor(energy / 10)
	if not enabled then maxLevel = 0 end


	local level = math.min(light_level, maxLevel)
	if level == 0 then
		minetest.swap_node(pos, {name = NAME .. ":light_off"})
	elseif level == 1 then
		minetest.swap_node(pos, {name = NAME .. ":light_lv1"})
	elseif level == 2 then
		minetest.swap_node(pos, {name = NAME .. ":light_lv2"})
	elseif level == 3 then
		minetest.swap_node(pos, {name = NAME .. ":light_lv3"})
	end
	return level
end



local optionsChanged = function(pos, name)
	local timer = minetest.get_node_timer(pos)
	if name == "enabled" then
		if sparktech.getoption(pos, name) then
			setEnergyLevelNode(pos)
			timer:start(1.0)
		else
			minetest.swap_node(pos, {name = NAME .. ":light_off"})
			timer:stop()
		end
	end
	if name == "light_level" then
		if setEnergyLevelNode(pos) > 0 then
			timer:start(1.0)
		else
			timer:stop()
		end
	end
end


local op_punch = function(pos)
	local lightLevel =  sparktech.getoption(pos, "light_level")
	lightLevel = lightLevel -1
	if lightLevel == -1 then lightLevel = 3 end

	sparktech.setoption(pos, "light_level", lightLevel)
end



local timer = function(pos, elapsed, energyDrain)
	local meta = minetest.get_meta(pos)
	local energy = meta:get_int("energy")

	if sparktech.getoption(pos, "enabled") then
		energy = energy - energyDrain
		meta:set_int("energy", energy)
	else
		minetest.swap_node(pos, {name = NAME .. ":light_off"})
		minetest.get_node_timer(pos):start(1.0) -- TODO: energy wakeup?
		return
	end
	setEnergyLevelNode(pos, 3)
	minetest.get_node_timer(pos):start(1.0) -- TODO: energy wakeup?
end


minetest.register_node(NAME .. ":light_off", {
	description = "Unpowered light",
	tiles = {
		NAME .. "_lamp_off.png",
	},
	on_timer = function(pos, elapsed) timer(pos, elapsed, 0) end,
	on_construct = function(pos, elapsed) timer(pos, elapsed, 0) end,
	on_punch = op_punch,
	groups = {
		sparktech_techy = WRENCHABLE,
		sparktech_energy_type = ENERGY_CONSUMER,
		sparktech_net_trigger = TRUE,
		sparktech_energy_max = MAX_ENERGY,
		sparktech_energy_wakeup = 10,
		sparktech_io = TRUE
	},
	_sparkoption = {
		enabled = true,
		light_level = 3
	},
	_sparkoutput = {
		brightness = function(node) return 0 end
	},
	_sparkoutputtype = {
		brightness = type(0)
	},
	_sparkoptionchanged = optionsChanged,
	light_source = 0
})


minetest.register_node(NAME .. ":light_lv1", {
  description = "Powered light (little)",
  tiles = {
    NAME .. "_lamp_1.png",
  },
	on_timer = function(pos, elapsed) timer(pos, elapsed, 1) end,
	on_construct = function(pos, elapsed) timer(pos, elapsed, 1) end,
	on_punch = op_punch,
	groups = {
		sparktech_techy = WRENCHABLE,
		sparktech_energy_type = ENERGY_CONSUMER,
		sparktech_net_trigger = TRUE,
		sparktech_energy_max = MAX_ENERGY,
		sparktech_energy_wakeup = 10,
		sparktech_io = TRUE,
		not_in_creative_inventory = 1
	},
	_sparkoption = {
		enabled = true,
		light_level = 3
	},
	_sparkoutput = {
		brightness = function(node) return 1 end
	},
	_sparkoutputtype = {
		brightness = type(1)
	},
	_sparkoptionchanged = optionsChanged,
	drop = NAME .. ":light_off",
	light_source = minetest.LIGHT_MAX / 3
})


minetest.register_node(NAME .. ":light_lv2", {
  description = "Powered light (medium)",
  tiles = {
    NAME .. "_lamp_2.png",
  },
	on_timer = function(pos, elapsed) timer(pos, elapsed, 2) end,
	on_construct = function(pos, elapsed) timer(pos, elapsed, 2) end,
	on_punch = op_punch,
	groups = {
		sparktech_techy = WRENCHABLE,
		sparktech_energy_type = ENERGY_CONSUMER,
		sparktech_net_trigger = TRUE,
		sparktech_energy_max = MAX_ENERGY,
		sparktech_energy_wakeup = 10,
		sparktech_io = TRUE,
		not_in_creative_inventory = 1
	},
	_sparkoption = {
		enabled = true,
		light_level = 3
	},
	_sparkoutput = {
		brightness = function(node) return 2 end
	},
	_sparkoutputtype = {
		brightness = type(2)
	},
	_sparkoptionchanged = optionsChanged,
	drop = NAME .. ":light_off",
	light_source = (2 *minetest.LIGHT_MAX /3)
})


minetest.register_node(NAME .. ":light_lv3", {
  description = "Powered light (big)",
  tiles = {
    NAME .. "_lamp_3.png",
  },
	on_timer = function(pos, elapsed) timer(pos, elapsed, 3) end,
	on_construct = function(pos, elapsed) timer(pos, elapsed, 3) end,
	on_punch = op_punch,
	groups = {
		sparktech_techy = WRENCHABLE,
		sparktech_energy_type = ENERGY_CONSUMER,
		sparktech_net_trigger = TRUE,
		sparktech_energy_max = MAX_ENERGY,
		sparktech_energy_wakeup = 10,
		sparktech_io = TRUE,
		not_in_creative_inventory = 1
	},
	_sparkoption = {
		enabled = true,
		light_level = 3
	},
	_sparkoutput = {
		brightness = function(node) return 3 end
	},
	_sparkoutputtype = {
		brightness = type(3)
	},
	_sparkoptionchanged = optionsChanged,
	drop = NAME .. ":light_off",
	light_source = minetest.LIGHT_MAX
})
