NAME = minetest:get_current_modname()

minetest.register_craftitem(NAME .. ":tracer", {
	inventory_image = NAME .. "_tracer.png"
})


minetest.register_craftitem(NAME .. ":holder", {
	inventory_image = NAME .. "_tracer.png"
})


minetest.register_craftitem(NAME .. ":grabber", {
	inventory_image = NAME .. "_tracer.png"
})


minetest.register_craftitem(NAME .. ":laser", {
	inventory_image = NAME .. "_tracer.png"
})


local box = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, .5, .5, .5},
	},
}

local tracer_box = {
	type = "fixed",
	fixed = {
		{-0.25, -0.5, -0.5, .25, .5, .5},
	},
}

minetest.register_entity(NAME .. ":tracer", {
	initial_properties = {
		visual = "mesh",
		mesh = "tracer.obj",
		physical = true,
	},
	collision_box = tracer_box,
	selection_box = tracer_box,
	pointable = true,
	textures = { NAME .. "_tracer_mesh.png" },
	automatic_rotate = 0,
	on_activate = function(self, staticdata, dtime_s)
		if not staticdata then return end
		local rot = staticdata
		if rot == "r" then
			self.object:set_rotation({x= 0, y=0, z=0 })
		end
		if rot == "l" then
			self.object:set_rotation({x= 0, y= math.pi, z=0 })
		end
		if rot == "f" then
			self.object:set_rotation({x= 0, y= math.pi /2, z=math.pi })
		end
		if rot == "b" then
			self.object:set_rotation({x= 0, y= math.pi + math.pi /2, z=math.pi })
		end
	end
})


minetest.register_entity(NAME .. ":grabber", {
	initial_properties = {
		visual = "mesh",
		mesh = "grabber.obj",
		physical = true,
	},
	collision_box = box,
	selection_box = box,
	pointable = true,
	textures = { NAME .. "_tracer_mesh.png" },
	automatic_rotate = 0,
})


minetest.register_entity(NAME .. ":laser", {
	initial_properties = {
		visual = "mesh",
		mesh = "laser.obj",
		physical = true,
	},
	collision_box = box,
	selection_box = box,
	pointable = true,
	textures = { NAME .. "_laser_mesh.png" },
	automatic_rotate = 0,
})


minetest.register_entity(NAME .. ":holder", {
	initial_properties = {
		visual = "mesh",
		mesh = "holder.obj",
		physical = true,
	},
	collision_box = box,
	selection_box = box,
	pointable = true,
	textures = { NAME .. "_tracer_mesh.png" },
	on_activate = function(self, staticdata, dtime_s)
		if not staticdata then return end
		local rot = staticdata
		if rot == "n" then
			self.object:set_rotation({x= 0, y=0, z=0 })
		end
		if rot == "u" then
			self.object:set_rotation({x=0 , y= math.pi/2, z= math.pi })
		end
	end,
	automatic_rotate = 0,
})

