NAME = minetest.get_current_modname()

minetest.register_node(NAME .. ":flax", {
	description = "Flax",
	groups = { flora = 1 },
	inventory_image = NAME .. "_flax_icon.png",
	node_dig_prediction = "air",
	tiles = { NAME .. "_flax_X.png"},
	drawtype = "plantlike",
	walkable = false,
	paramtype = "light",
	buildable_to = true,
	selection_box = {
		type = "fixed",
			fixed = {
				{-0.31, -0.5, -0.31, 0.31, 0.35, 0.31},
			},
	},
})
minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:grass",
	decoration = NAME .. ":flax",
	name = NAME .. ":flax",
	noise_params = {
		offset = 0,
		scale = 0.002,
		spread = {x = 2, y = 5, z = 2},
		seed = 354,
		octaves = 3,
		persistence = 0.6,
		lacunarity = 2.0,
		flags = "absvalue"
	},
	height = 1,
})
