function sparktech.empty_inventory(source, destination, listname) ---
	--- expects those in already inventory formats
	--                               
	local inventory_lists = source:get_lists()
	
	if not inventory_lists then return true end
	for i, list in pairs(inventory_lists) do
		for n=1, #list do
			if destination:room_for_item(listname, list[n]) then
				destination:add_item("main", list[n])
			else
				return false
			end
		end
	end

	return true
end 


function sparktech.drop_inventory(nodepos, quilty) ---
	--- evacutate the mines, quickly now!
	local inventory_lists = minetest.get_meta(nodepos):get_inventory():get_lists()

	for i, list in pairs(inventory_lists) do
		for n=1, #list do
			minetest.item_drop(list[n], quilty, nodepos)
		end
	end
end


function sparktech.dig_node(nodepos, inventory, listname, strictmode, quilty) ---
	--- call with position, your inventory, and the listname
	-- strictmode true: give me all you can
	-- strictmode false: it is okay to drop items to the ground
	local node = minetest.get_node(nodepos)
	local nodedrop = minetest.registered_nodes[node["name"]].drop or node["name"]
	if node["name"] == "air" or node["name"] == "ignore" then return false end
	local node_inv = minetest.get_meta(nodepos):get_inventory()
	--local node_drops = minetest.get_node_drops(node)
	if not sparktech.empty_inventory(node_inv, inventory, listname) then 
		if not strictmode then
			sparktech.drop_inventory(nodepos)
		else
			return false
		end
	end

	-- TODO rebuild node grid (energy distribution)
	if inventory:room_for_item(listname, ItemStack(nodedrop)) then
		inventory:add_item(listname, ItemStack(nodedrop)) -- TODO STORE ENERGY sparktech_store_onbreak or something
	else
		if not strictmode then
			minetest.item_drop(ItemStack(nodedrop), quilty, nodepos) -- TODO STORE ENERGY
		else
			return false
		end
	end
	minetest.remove_node(nodepos)
	return true
end

