local NAME = minetest.get_current_modname()
local MAX_ENERGY = 50

minetest.register_node(NAME .. ":solar", {
  description = "Solar Cell",
  tiles = {
    "solar_top.png",
    "solar_side.png"
  },
  drawtype = "nodebox",
  paramtype = "light",
  node_box = {
    type = "fixed",
    fixed = {
       {0.5, -0.2, 0.5, -0.5, 0.2, -0.5},
       {-0.2, -0.5, -0.2, 0.2, -0.2, 0.2}
    }
  },
	connect_sides = {"bottom", "front", "left", "back", "right" },
  groups = {
    sparktech_techy = WRENCHABLE,
    sparktech_energy_type = ENERGY_PRODUCER,
    sparktech_net_trigger = TRUE,
    sparktech_energy_max = MAX_ENERGY,
		sparktech_io = TRUE
  },
  _sparkoptionchanged = function(pos, name)
  	-- Don't need to handle enabled here because solar runs on an ABM
	end,
	_sparkoption = {
		enabled = true,
	},
	_sparkoutput = {
		lightLevel = function(nodepos)
    -- TODO: cap this at light that the sun /can/ generator for this time
			return minetest.get_node_light(nodepos)
		end
	},
	_sparkoutputtype = {
		lightLevel = type(1)
	}
})


minetest.register_abm({
	nodenames = {minetest.get_current_modname() .. ":solar"},
	interval = 1.0,
	chance = 1,
	catch_up = true,
	action = function(pos, node, active_object_count, active_object_count_wider)
		if sparktech.getoption(pos, "enabled") then
			local meta = minetest.get_meta(pos)
			-- TODO: cap this at light that the sun /can/ generator for this time
			meta:set_int("energy", meta:get_int("energy") + 2 * ( minetest.get_node_light(pos) / 15 ) ) -- this needs to be sunlight only... api missing
			local emax = minetest.get_item_group(node.name, "sparktech_energy_max")
			if meta:get_int("energy") > emax then
			  meta:set_int("energy", emax)
			end
		end
	end
})


minetest.register_craft({
    output = NAME .. ":solar",
    recipe = {
      { "orionworld:glass", "orionworld:glass", "orionworld:glass" },
      { "sparkcore:cable", "orioncraft:copper_bar", "sparkcore:cable" },
      { "orioncraft:iron_bar", "orioncraft:iron_bar", "orioncraft:iron_bar"},
    }
})
