local NAME = minetest.get_current_modname()

local CAPACITY = 500
local MAX_WEAR = 65535

local TOOL = {}

TOOL.CAPS = {
	EMPTY = { },
	FULL = {
		groupcaps = {
			solids = {
				times = { --TOOO [balancing]
					 [1] = 0.5,
					 [2] = 1.2,
					 [3] = 1.8,
					 [4] = 2.2
				},
				maxlevel = 4
			}
		}
	}
}

minetest.register_tool(NAME .. ":handdrill", {
	description = "Electric Handdrill",
	inventory_image = NAME .. "_drill.png",
	range = 6.0,
	stack_max = 1,
	groups = {
		sparktech_chargeable = CAPACITY
	},
	tool_capabilities = TOOL.CAPS.EMPTY,
	spark_caps_charge = TOOL.CAPS.FULL,
	spark_caps_empty = TOOL.CAPS.EMPTY,
	after_use = function (itemstack, user, node, digparams)
		local item_meta = itemstack:get_meta()
		local item_charge = item_meta:get_int("energy") or 0

		item_charge = item_charge - 1
		if item_charge <= 0 then
			itemstack:set_wear(MAX_WEAR)
			item_meta:set_tool_capabilities(TOOL.CAPS.EMPTY)
		end

		item_meta:set_int("energy", item_charge)

		return
	end
})

minetest.register_craft({
	output = NAME .. ":handdrill",
	recipe = {
		{ "", "orioncraft:iron_bar", "" },
		{ "orioncraft:iron_bar", "", "orioncraft:iron_bar" },
		{ "orioncraft:tin_bar", "orioncraft:copper_bar", "orioncraft:tin_bar" },
	}
})
