orion.register_nodebar = function(mod, name, description)
	minetest.register_node(mod .. ":" .. name, {
		description = description,
		drawtype = "mesh",
		mesh = "bar.obj",
		tiles = { mod .. "_" .. name .. "_mesh.png" },
		node_placement_prediction = "",
		visual_scale = 0.4,
		wield_scale = {x = 0.2, y = 0.2, z = 0.2},
		on_place = function(itemstack, placer, pointed_thing)
			return minetest.item_drop(itemstack, placer)
		end,
		on_secondary_use = function(itemstack, placer, pointed_thing)
			return minetest.item_drop(itemstack, placer)
		end
	})
end


orion.register_smeltable = function(mod, name, recipe)
	local newRecipe = {}
	newRecipe[recipe] = 1
	local newResult = {}
	newResult[mod .. ":" .. name] = 1
	orion.craft.register("smelting", newRecipe,  newResult)
end


orion.register_smeltable_bar = function(mod, name, description, recipe)
	orion.register_nodebar(mod, name, description)
	orion.register_smeltable(mod, name, recipe)
	minetest.register_entity(mod .. ":" ..name, {
		collisionbox = {0.2, 0.0, 0.1, -0.2, 0.1, -0.1},
		physical = true,
		pointable = true,
		visual = "mesh",
		mesh = "bar.obj",
		textures = { mod .. "_" .. name .. "_mesh.png" },
		automatic_rotate = 0,
		on_punch = function(punchee, puncher)
			local inv = puncher:get_inventory()
			local item = ItemStack(punchee.name)
			if inv:room_for_item("main",item) then
				inv:add_item("main",item)
				punchee.object:remove()
			end
		end,
		on_step = function(self, dtime, moveresult)
			local velocity = self.object:get_velocity()
			self.object:set_velocity({
				x = velocity.x - velocity.x * 0.90 * dtime,
				y = velocity.y,
				z = velocity.z - velocity.z * 0.90 * dtime
			})
		end
	})
end
