local NAME = minetest.get_current_modname()

minetest.register_node(NAME ..":cable", {
	description = "Copper Cable",
	tiles = {"cable.png"},
	drawtype = "nodebox",
	paramtype = "light",
	connects_to = {"group:sparktech_net_trigger", "group:sparktech_net_passive"},
	node_box = {
		type = "connected",
		disconnected = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
		connect_top = {-0.2, -0.2, -0.2, 0.2, 0.8, 0.2},
		connect_bottom = {-0.2, -0.8, -0.2, 0.2, 0.2, 0.2},
		connect_back = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.8},
		connect_right = {-0.2, -0.2, -0.2, 0.8, 0.2, 0.2},
		connect_front = {-0.2, -0.2, -0.8, 0.2, 0.2, 0.2},
		connect_left = {-0.8, -0.2, -0.2, 0.2, 0.2, 0.2},
	},
	groups = {
		sparktech_techy = 1,
		sparktech_net_passive = 1,}
})

minetest.register_craft({
	output = NAME .. ":cable 16",
	type = "shapeless",
	recipe = { 'orioncraft:copper_bar'}
})
