sparktech.energy_hud = {}

local spark_dig_stlye_alt = minetest.settings:get_bool("spark_dig_stlye_alt")
local on_use = nil
if spark_dig_stlye_alt then
	on_use = function() return nil end
end

minetest.register_tool("sparkdebug:multimeter", {
	description = "Multimeter",
	inventory_image = "multimeter.png",
	stack_max = 1,
	on_use = on_use,
	on_place = function(itemstack, placer, pointed_thing)
		if pointed_thing["type"] == "node" then
			sparktech.energy_hud[placer:get_player_name()]["pos"] = pointed_thing["under"]
		end
		return itemstack
	end
})

minetest.register_on_joinplayer(function(player)
	local energyBar = player:hud_add({
		hud_elem_type = "statbar",
		position = { x = 0.5, y = 0.5 },
		offset = { x = -100, y = -160 },
		text = "bar_red.png",
		direction = 0,
		size = { x = 1, y = 20 }, -- looks correct with 2, less is invisble, more is too big :/
		number = 20
	})
	local textEnergy = player:hud_add({
		hud_elem_type = "text",
		position = { x = 0.5, y = 0.5 },
		offset = { x = 0, y = -170 },
		text = "",
		direction = 0,
		number = tonumber ("0xFFFFFF", 16)
	})
	local textMaster = player:hud_add({
		hud_elem_type = "text",
		position = { x = 0.5, y = 0.5 },
		offset = { x = 0, y = -120 },
		text = "",
		direction = 0,
		number = tonumber ("0xFFFFFF", 16)
	})
	local nodeOptionsText = player:hud_add({
		hud_elem_type = "text",
		position = { x = 0.5, y = 0.5 },
		offset = { x = -150, y = 0 },
		alignment = { x = 1, y = 0 },
		text = "",
		direction = 0,
		number = tonumber ("0xFFFFFF", 16)
	})
	sparktech.energy_hud[player:get_player_name()] = {
		energyBar = energyBar,
		textEnergy = textEnergy,
		textMaster = textMaster,
		nodeOptionsText = nodeOptionsText,
		pos = { x = 0, y = 0, z = 0 }
	}
end)

minetest.register_globalstep(function(dtime)
	for k, i in pairs(sparktech.energy_hud) do
		local meta = minetest.get_meta(i["pos"])
		local node = minetest.get_node(i["pos"])
		local player = minetest.get_player_by_name(k)
		if player == nil then
			return
		end

		player:hud_change(i["energyBar"], "number", meta:get_int("energy") / minetest.get_item_group(node.name, "sparktech_energy_max") * 400)
		local val = minetest.get_item_group(node.name, "sparktech_energy_max")
		if val == 0 then
			player:hud_change(i["textEnergy"], "text", "")
		else
			player:hud_change(i["textEnergy"], "text", meta:get_int("energy") .. " / " .. val)
		end
		local hudString = "Options\n"
		if minetest.registered_nodes[node.name]._sparkoption then
			for optionname, default in pairs(minetest.registered_nodes[node.name]._sparkoption) do
				local option = sparktech.getoption(i["pos"], optionname)
				hudString = hudString .. optionname .. "["..type(default) .. "]: "
				hudString = hudString .. tostring(option) .. " (" .. tostring(default) .. ")\n"
			end
			hudString = hudString .. "\n\nValues\n"
			if minetest.registered_nodes[node.name]._sparkoutput then
				for outputname, outputfunc in pairs(minetest.registered_nodes[node.name]._sparkoutput) do
					local output = sparktech.getoutput(i["pos"], outputname)
					local outputType = sparktech.getoutputtype(i["pos"], outputname)
					if outputType == "number" then
						hudString = hudString .. outputname .. ": " .. tostring(output) ..  " (number)\n"
					elseif outputType == "string" then
						hudString = hudString .. outputname .. ": " .. output .. " (string)\n"
					elseif outputType == "ItemStack" then
						if output:is_empty() then
							hudString = hudString .. outputname ..  ": No item\n"
						else
							hudString = hudString  .. outputname .. ": " .. output:get_name() .. "[" .. output:get_count() .. "] (item)\n"
						end
					elseif outputType == "Inventory" then
						hudString = hudString .. outputname .. ": Inventory (viewing not implemented)"
					elseif outputType == "InventoryList" then
						local count = 1
						for listItemName, listItem in pairs(output) do
							hudString = hudString .. outputname .. "[" .. count .. "]:" .. listItem:get_name() .. "[" .. listItem:get_count() .. "] (item)\n"
							count = count +1
						end
					else
						hudString = hudString .. outputType .. "?\n".. dump2(output)
					end
				end
			end
			player:hud_change(i["nodeOptionsText"], "text", hudString)
		else
			player:hud_change(i["nodeOptionsText"], "text", "")
		end
		
		player:hud_change(i["textMaster"], "text", meta:get_string("net_master"))
		end
end)
