local NAME = minetest.get_current_modname()

local CAPACITY = 500
local MAX_WEAR = 65535

local TOOL = {}

TOOL.CAPS = {
	EMPTY = { },
	FULL = {
		groupcaps = {
			flora = { -- TODO [balancing] [rename group]
				times = {
					[1] = 0.1,
					[2] = 0.1,
					[3] = 0.2,
					[4] = 0.3
				}
			}
		}
	}
}

minetest.register_tool(NAME .. ":powersaw", {
	description = "Electric saw",
	inventory_image = NAME .. "_saw.png",
	range = 6.0,
	stack_max = 1,
	groups = {
		sparktech_chargeable = CAPACITY
	},
	tool_capabilities = TOOL.CAPS.EMPTY,
	spark_caps_charge = TOOL.CAPS.FULL,
	spark_caps_empty = TOOL.CAPS.EMPTY,
	after_use = function (itemstack, user, node, digparams)
		local item_meta = itemstack:get_meta()
		local item_charge = item_meta:get_int("energy") or 0

		item_charge = item_charge - 1
		if item_charge <= 0 then
			itemstack:set_wear(MAX_WEAR)
			item_meta:set_tool_capabilities(TOOL.CAPS.EMPTY)
		end

		item_meta:set_int("energy", item_charge)

		return
	end
})

minetest.register_craft({
	output = NAME .. ":powersaw",
	recipe = {
		{ "", "", "" },
		{ "orioncraft:iron_bar", "orioncraft:iron_bar", "orioncraft:iron_bar" },
		{ "orioncraft:tin_bar", "orioncraft:copper_bar", "orioncraft:tin_bar" },
	}
})
