local function process(itemstack, curr, node)
	local meta = itemstack:get_meta()
	local last = meta:to_table().fields
	if last.x then
		local xmin = math.min(last.x,curr.x)
		local ymin = math.min(last.y,curr.y)
		local zmin = math.min(last.z,curr.z)
		local xmax = math.max(last.x,curr.x)
		local ymax = math.max(last.y,curr.y)
		local zmax = math.max(last.z,curr.z)
		for y = 0,ymax-ymin do
			for x = xmin,xmax do
				for z = zmin,zmax do
					minetest.set_node({x=x,y=ymax-y,z=z}, {name=node})
				end
			end
		end
		meta:from_table(nil)
	else
		meta:from_table({fields=curr})
	end
	return itemstack
end

minetest.register_chatcommand("fillblock", {
	desc = "Set the fill block for the Land Clear tool",
	params = "nodestring",
	func = function (name, param)
		local player = minetest.get_player_by_name(name)
		if player then
			player:set_attribute("sparkdebug_clearnode", param)
			return true, "It is done."
		else
			return false, "Player not online."
		end
	end
})

minetest.register_tool("sparkdebug:landclear", {
	description = "Land Clear",
	inventory_image = "landclear.png",
	stack_max = 1,
	range = 50.0,
	on_use = function(itemstack, player, pointed_thing)
		if pointed_thing["type"] == "node" then
			return process(itemstack, pointed_thing.under, player:get_attribute("sparkdebug_clearnode") or "air")
		end
		return itemstack
	end,
	on_place = function(itemstack, placer, pointed_thing)
		return process(itemstack, placer:get_pos(), placer:get_attribute("sparkdebug_clearnode") or "air")
	end
})
