local NAME = minetest.get_current_modname()

minetest.register_tool(NAME .. ":screwdriver", {
	description = "Screwdriver",
	inventory_image = NAME .. "_screwdriver.png",
	range = 6.0,
	stack_max = 1,
	tool_capabilities = {},
	on_place = function (_, player, pointed_thing)
		local node = nil
		if pointed_thing["type"] == "node" then
			node = pointed_thing["under"]
		else
			return nil
		end
		local option = sparktech.getoption(node, "enabled")
		option = not option
		sparktech.setoption(node, "enabled", option)
		return nil
	end
})

