NAME = minetest.get_current_modname()

minetest.register_node(NAME .. ":grass_top", {
	description = "Grass",
	groups = { flora = 1 },
	inventory_image = NAME .. "_grass_icon.png",
	node_dig_prediction = "air",
	tiles = { NAME .. "_grass_X.png"},
	drawtype = "plantlike",
	walkable = false,
	paramtype = "light",
	buildable_to = true,
	selection_box = {
		type = "fixed",
			fixed = {
				{-0.31, -0.5, -0.31, 0.31, -0.2, 0.31},
			},
	},
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = "orionworld:grass",
	decoration = NAME .. ":grass_top",
	name = NAME .. ":grass_top",
	noise_params = {
		offset = 0,
		scale = 0.06,
		spread = {x = 2, y = 5, z = 2},
		seed = 354,
		octaves = 3,
		persistence = 1.0,
		lacunarity = 2.0,
		flags = "absvalue"
	},
	height = 1,
})
