NAME = minetest:get_current_modname()
INT32_MAX =  2147483647
INT32_MIN = -2147483648

local distribution = {}
distribution.big = {}
distribution.small = {}

distribution.small.scatter = {
	ore_type = "scatter",
	wherein = NAME .. ":stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 12,
	clust_size = 6,
}

distribution.big.scatter = {
	ore_type = "scatter",
	wherein = NAME .. ":stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 26,
	clust_size = 8,
}

distribution.small.puff = {
	ore_type = "puff",
}

distribution.big.puff = {
	ore_type = "puff",
}

distribution.small.vain = {

}

local function register_ore(name, description, alias, ore_distribution)
	orion.register_slab_node(NAME .. ":" .. name, {
		description = description,
		tiles= { NAME .. "_" .. name .. ".png" },
		groups = { solids = 4 }
	})
	minetest.register_alias(alias, NAME .. ":" .. name)
	if not ore_distribution then ore_distribution = distribution.small.scatter end
	ore_distribution.ore = NAME .. ":" .. name
	if not ore_distribution.wherein then ore_distribution.wherein = NAME .. ":stone" end
	minetest.register_ore(ore_distribution)
end

register_ore("Cu", "Copper ore", "copper", distribution.big.scatter)
register_ore("Fe", "Iron ore", "iron", distribution.big.scatter)
register_ore("Mg", "Magnesium ore", "magnesium", distribution.small.scatter)
register_ore("Ni", "Nickel ore", "nickel")
register_ore("Au", "Gold ore","gold")
register_ore("Sn", "Tin ore", "tin")
