local iodebug = true

sparktech.listoptions = function(nodepos)
	local node = minetest.get_node(nodepos)
	local meta = minetest.get_meta(nodepos)
	local optionsdef = minetest.registered_nodes[node.name]._sparkoption
	return optionsdef
end

sparktech.getoption = function(nodepos, optionname)
	local node = minetest.get_node(nodepos)
	local meta = minetest.get_meta(nodepos)
	local optionsdef = minetest.registered_nodes[node.name]._sparkoption
	if iodebug and not optionsdef then error("Getoption called on node that shouldn't have options!") end
	if iodebug and not optionsdef[optionname] then
		error("optioname " ..optionname .. " for " .. node.name .." is not defined!")
	end
	local resultMeta = meta:get(optionname)
	if resultMeta ~= nil then
		return minetest.deserialize(resultMeta)
	else
		return minetest.registered_nodes[node.name]._sparkoption[optionname]
	end
end


sparktech.setoption = function(nodepos, optionname, optionvalue)
	local node = minetest.get_node(nodepos)
	local meta = minetest.get_meta(nodepos)
	local optionsdef = minetest.registered_nodes[node.name]._sparkoption
	if iodebug and not optionsdef[optionname] then
		error("optioname " .. optionname .. " for " .. node.name .." is not defined!")
	end
	meta:set_string(optionname, minetest.serialize(optionvalue))
	minetest.registered_nodes[node.name]._sparkoptionchanged(nodepos, optionname)
end


sparktech.getoutput = function(nodepos, outputname)
	assert(nodepos, "No position passed to getoutput!")
	assert(outputname, "No name passed to getoutput!")
	local sparkfunction = minetest.registered_nodes[minetest.get_node(nodepos).name]._sparkoutput[outputname]
	return sparkfunction(nodepos)
end


sparktech.getoutputtype = function(nodepos, outputname)
	return minetest.registered_nodes[minetest.get_node(nodepos).name]._sparkoutputtype[outputname]
end
