local NAME = minetest.get_current_modname()
local MAX_ENERGY = 5000

minetest.register_node(NAME ..":capacitor", {
  description = "Capacitor",
  tiles = {
    "capacitor_top.png",
    "capacitor_top.png",
    "capacitor_side.png",
    "capacitor_side.png",
    "capacitor_side.png",
    "capacitor_side.png"
  },
  groups = {
    sparktech_techy = WRENCHABLE,
    sparktech_energy_type = ENERGY_STORE,
    sparktech_energy_storeonbreak = TRUE,
    sparktech_energy_max = MAX_ENERGY,
    sparktech_net_trigger = TRUE,
  },
	_sparkoptionchanged = function(pos, name)
		error("Sparkoptionchanged called with no options defined!")
	end,
  _sparkoption = {
		--TODO: Implement this, may need changes in net_code to respect meta for max or min?
		--enabled = true,
		--minLevel = 0,
		--maxLevel = MAX_ENERGY
	},
	_sparkoutput = {
		energyLevel = function(nodepos) --todo adjust for maxLevel
			return minetest.get_meta(nodepos):get_int("energy") / MAX_ENERGY
		end,
	},
	_sparkoutputtype = {
		energyLevel = type(0)
	}
})

minetest.register_craft({
    output = NAME .. ":capacitor",
    recipe = {
      { "orioncraft:iron_bar", "orioncraft:copper_bar", "orioncraft:iron_bar" },
      { "orioncraft:copper_bar", "sparkcore:cable", "orioncraft:copper_bar" },
      { "orioncraft:iron_bar", "orioncraft:copper_bar", "orioncraft:iron_bar" },
    }
})
