local function make_scale(player) -- make this an API call, also used in join player
		local shaplayer = minetest.sha1(player:get_player_name(), true)
		local rand = shaplayer:byte(1)
		scale = shaplayer:byte(1) / 256 /2
		scale = scale + 0.75
		return scale
end


local orig_drop = minetest.item_drop
minetest.item_drop = function(itemstack, user, position)

	if not minetest.is_player(user)
		then return orig_drop(itemstack, user, position)
	end

	local drops = itemstack:peek_item(1)
	if not minetest.registered_entities[drops:get_name()] then
		return orig_drop(itemstack, user, position)
	end
	if not position then position = user:get_pos() end
	local velocity = user:get_velocity()

	local scale = tonumber(user:get_meta():get_string("scale"))
	if not scale then scale = make_scale(user) end

	local eye_height = 1.75 + scale - 0.375
	local dir = user:get_look_dir()
	dir.x = dir.x * 3
	dir.y = dir.y * 3
	dir.z = dir.z * 3
	position.y = position.y + eye_height
	dir = vector.normalize(dir)
	position.x = position.x + dir.x * 0.2
	position.z = position.z + dir.z * 0.2
	position.y = position.y + dir.y * 0.2
	local entity = minetest.add_entity(position, drops:get_name(), drops:get_name())
	entity:set_acceleration({x=0, y= -1, z=0})
	entity:set_velocity(velocity)
	entity:add_velocity(dir)
	
	if entity then
		local drops = itemstack:take_item(1)
	end
	return itemstack
end
