NAME = minetest:get_current_modname()

minetest.register_alias("mapgen_river_water_source", NAME .. ":water")
minetest.register_alias("mapgen_water_source", NAME .. ":water")

minetest.register_node(NAME .. ":water", {
	liquid_range = 16,
	alpha = 128,
	renewable = false,
	drawtype = "liquid",
	paramtype = "light",
	description = "Water",
	tiles = { NAME .. "_water.png" },
	special_tiles = {
		{name = NAME .. "_water.png"},
		{name = NAME .. "_water.png"},
	},
	walkable = false,
	pointable = false,
	liquidtype = "source",
	waving = 3,
	buildable_to = true,
	liquid_alternative_source = NAME .. ":water",
	liquid_alternative_flowing = NAME .. ":water_flowing",
	liquid_viscosity = 1,
	liquid_renewable = false,
})


minetest.register_node(NAME .. ":water_flowing", {
	liquid_range = 16,
	alpha = 128,
	drawtype = "flowingliquid",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	description = "Water",
	tiles = { NAME .. "_water.png" },
	special_tiles = {
		{name = NAME .. "_water.png",}, -- top, bottom
		{name = NAME .. "_water.png",}, -- side face
	},
	walkable = false,
	pointable = false,
	liquidtype = "flowing",
	waving = 3,
	buildable_to = true,
	liquid_alternative_source = NAME .. ":water",
	liquid_alternative_flowing = NAME .. ":water_flowing",
	liquid_viscosity = 1,
	liquid_renewable = false,
})
