minetest.register_node("sparkdebug:energyvoid", {
  description = "Energy Void",
  tiles = {
    "capacitor_top.png",
    "capacitor_top.png",
    "capacitor_side.png",
    "capacitor_side.png",
    "capacitor_side.png",
    "capacitor_side.png"
  },
  groups = {
    sparkdebug = TRUE,
    sparktech_energy_type = ENERGY_CONSUMER,
    sparktech_net_trigger = TRUE,
    sparktech_energy_max = 10000,
    sparktech_techy = WRENCHABLE
  }
})
minetest.register_node("sparkdebug:energysource", {
  description = "Energy Source",
  tiles = {
    "capacitor_top.png",
    "capacitor_top.png",
    "capacitor_side.png",
    "capacitor_side.png",
    "capacitor_side.png",
    "capacitor_side.png"
  },
  groups = {
    sparkdebug = TRUE,
    sparktech_energy_type = ENERGY_PRODUCER,
    sparktech_net_trigger = TRUE,
    sparktech_energy_max = 10000,
    sparktech_techy = WRENCHABLE
  }
})

minetest.register_abm({
	nodenames = {"group:sparkdebug"},
	interval = 1.0,
  chance = 1,
  catch_up = true,
  action = function(pos, node, active_object_count, active_object_count_wider)
    local meta = minetest.get_meta(pos)
    if node["name"] == "sparkdebug:energysource" then
      meta:set_int("energy", 10000)
    end
    if node["name"] == "sparkdebug:energyvoid" then
      meta:set_int("energy", 0)
    end
  end
})
